/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.platform.plugin.PluginEntity;
import io.gravitee.rest.api.service.ConnectorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Plugins"})
public class ConnectorResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ConnectorService connectorService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a connector", notes="User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Connector plugin", response=PluginEntity.class), @ApiResponse(code=404, message="Connector not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public PluginEntity getConnector(@PathParam(value="connector") String connector) {
        return this.connectorService.findById(connector);
    }

    @GET
    @Path(value="schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a connector's schema", notes="User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Connector schema", response=String.class), @ApiResponse(code=404, message="Connector not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getConnectorSchema(@PathParam(value="connector") String connector) {
        this.connectorService.findById(connector);
        return this.connectorService.getSchema(connector);
    }

    @GET
    @Path(value="documentation")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get a connector's documentation", notes="User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Connector documentation", response=String.class), @ApiResponse(code=404, message="Connector not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getConnectorDoc(@PathParam(value="connector") String connector) {
        this.connectorService.findById(connector);
        return this.connectorService.getDocumentation(connector);
    }
}

