/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.exception.InvalidImageException;
import io.gravitee.rest.api.management.rest.resource.AbstractCategoryResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.UpdateCategoryEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.security.utils.ImageUtils;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.CategoryNotFoundException;
import io.gravitee.rest.api.service.exceptions.UnauthorizedAccessException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayOutputStream;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Api(tags={"Categories"})
public class CategoryResource
extends AbstractCategoryResource {
    @Inject
    private CategoryService categoryService;
    @PathParam(value="categoryId")
    @ApiParam(name="categoryId", required=true)
    private String categoryId;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the category", notes="User must have the PORTAL_CATEGORY[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Category's definition", response=CategoryEntity.class), @ApiResponse(code=500, message="Internal server error")})
    public CategoryEntity getCategory() {
        boolean canShowCategory = this.hasPermission(RolePermission.ENVIRONMENT_CATEGORY, RolePermissionAction.READ);
        CategoryEntity category = this.categoryService.findById(this.categoryId, GraviteeContext.getCurrentEnvironment());
        if (!canShowCategory && category.isHidden()) {
            throw new UnauthorizedAccessException();
        }
        this.setPictures(category, false);
        return category;
    }

    @GET
    @Path(value="picture")
    @ApiOperation(value="Get the category's picture", notes="User must have the PORTAL_CATEGORY[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Category's picture"), @ApiResponse(code=500, message="Internal server error")})
    public Response getCategoryPicture(@Context Request request) throws CategoryNotFoundException {
        return this.getImageResponse(request, this.categoryService.getPicture(GraviteeContext.getCurrentEnvironment(), this.categoryId));
    }

    @GET
    @Path(value="background")
    @ApiOperation(value="Get the Category's background", notes="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Category's background"), @ApiResponse(code=500, message="Internal server error")})
    public Response getCategoryBackground(@Context Request request) throws CategoryNotFoundException {
        return this.getImageResponse(request, this.categoryService.getBackground(GraviteeContext.getCurrentEnvironment(), this.categoryId));
    }

    private Response getImageResponse(Request request, InlinePictureEntity image) {
        boolean canShowCategory = this.hasPermission(RolePermission.ENVIRONMENT_CATEGORY, RolePermissionAction.READ);
        CategoryEntity category = this.categoryService.findById(this.categoryId, GraviteeContext.getCurrentEnvironment());
        if (!canShowCategory && category.isHidden()) {
            throw new UnauthorizedAccessException();
        }
        CacheControl cc = new CacheControl();
        cc.setNoTransform(true);
        cc.setMustRevalidate(false);
        cc.setNoCache(false);
        cc.setMaxAge(86400);
        if (image == null || image.getContent() == null) {
            return Response.ok().build();
        }
        EntityTag etag = new EntityTag(Integer.toString(new String(image.getContent()).hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
        if (builder != null) {
            return builder.cacheControl(cc).build();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(image.getContent(), 0, image.getContent().length);
        return Response.ok((Object)baos).cacheControl(cc).tag(etag).type(image.getType()).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the category", notes="User must have the PORTAL_CATEGORY[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Category successfully updated", response=CategoryEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CATEGORY, acls={RolePermissionAction.UPDATE})})
    public Response updateCategory(@Valid @NotNull UpdateCategoryEntity category) {
        try {
            ImageUtils.verify((String)category.getPicture());
            ImageUtils.verify((String)category.getBackground());
        }
        catch (InvalidImageException e) {
            throw new BadRequestException("Invalid image format");
        }
        CategoryEntity categoryEntity = this.categoryService.update(this.categoryId, category);
        this.setPictures(categoryEntity, false);
        return Response.ok((Object)categoryEntity).build();
    }

    @DELETE
    @ApiOperation(value="Delete the category", notes="User must have the PORTAL_CATEGORY[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Category successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CATEGORY, acls={RolePermissionAction.DELETE})})
    public void deleteCategory() {
        this.categoryService.delete(this.categoryId);
    }
}

