/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.quality.ApiQualityRuleEntity;
import io.gravitee.rest.api.model.quality.NewApiQualityRuleEntity;
import io.gravitee.rest.api.model.quality.UpdateApiQualityRuleEntity;
import io.gravitee.rest.api.service.ApiQualityRuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Api(tags={"API Quality"})
public class ApiQualityRulesResource
extends AbstractResource {
    @Inject
    private ApiQualityRuleService apiQualityRuleService;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;

    @GET
    @ApiOperation(value="List quality rules for an API", notes="User must have the API_QUALITY_RULE[READ] permission to use this service")
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_QUALITY_RULE, acls={RolePermissionAction.READ})})
    public List<ApiQualityRuleEntity> getApiQualityRules() {
        return this.apiQualityRuleService.findByApi(this.api);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new quality rules for an API", notes="User must have the API_QUALITY_RULE[CREATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_QUALITY_RULE, acls={RolePermissionAction.CREATE})})
    public ApiQualityRuleEntity createApiQualityRule(@Valid @NotNull NewApiQualityRuleEntity apiQualityRuleEntity) {
        apiQualityRuleEntity.setApi(this.api);
        return this.apiQualityRuleService.create(apiQualityRuleEntity);
    }

    @Path(value="{qualityRule}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an existing quality rules for an API", notes="User must have the API_QUALITY_RULE[UPDATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_QUALITY_RULE, acls={RolePermissionAction.UPDATE})})
    public ApiQualityRuleEntity updateApiQualityRule(@PathParam(value="qualityRule") String qualityRule, @Valid @NotNull UpdateApiQualityRuleEntity apiQualityRuleEntity) {
        apiQualityRuleEntity.setApi(this.api);
        apiQualityRuleEntity.setQualityRule(qualityRule);
        return this.apiQualityRuleService.update(apiQualityRuleEntity);
    }
}

