/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.GroupMemberEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

public class ApiGroupsResource
extends AbstractResource {
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String apiId;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get API groups mapped to members", notes="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API groups with members", response=MemberEntity.class, responseContainer="Map"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=500, message="Internal Server Error")})
    @Permissions(value={@Permission(value=RolePermission.API_MEMBER, acls={RolePermissionAction.READ})})
    public Map<String, List<GroupMemberEntity>> getApiGroupsWithMembers() {
        return this.apiService.getGroupsWithMembers(GraviteeContext.getCurrentEnvironment(), this.apiId);
    }
}

