/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.filter;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.UnauthorizedAccessException;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=200)
public class PermissionsFilter
implements ContainerRequestFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Context
    protected ResourceInfo resourceInfo;
    @Inject
    private SecurityContext securityContext;
    @Inject
    private MembershipService membershipService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private ApiService apiService;
    @Inject
    private RoleService roleService;
    @Inject
    private GroupService groupService;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.securityContext.isUserInRole(AbstractResource.ORGANIZATION_ADMIN)) {
            this.logger.debug("User [{}] has full access because of its ADMIN role", (Object)this.securityContext.getUserPrincipal().getName());
            return;
        }
        this.filter(this.getRequiredPermission(), requestContext);
    }

    protected void filter(Permissions permissions, ContainerRequestContext requestContext) {
        if (permissions != null && permissions.value().length > 0) {
            Principal principal = this.securityContext.getUserPrincipal();
            if (principal != null) {
                String username = principal.getName();
                block7: for (Permission permission : permissions.value()) {
                    switch (permission.value().getScope()) {
                        case ORGANIZATION: {
                            Map memberPermissions = this.membershipService.getUserMemberPermissions(GraviteeContext.getCurrentEnvironment(), MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization(), username);
                            if (!this.roleService.hasPermission(memberPermissions, permission.value().getPermission(), permission.acls())) continue block7;
                            return;
                        }
                        case ENVIRONMENT: {
                            Map memberPermissions = this.membershipService.getUserMemberPermissions(GraviteeContext.getCurrentEnvironment(), MembershipReferenceType.ENVIRONMENT, GraviteeContext.getCurrentEnvironment(), username);
                            if (!this.roleService.hasPermission(memberPermissions, permission.value().getPermission(), permission.acls())) continue block7;
                            return;
                        }
                        case APPLICATION: {
                            ApplicationEntity application = this.getApplication(requestContext);
                            Map memberPermissions = this.membershipService.getUserMemberPermissions(GraviteeContext.getCurrentEnvironment(), application, username);
                            if (!this.roleService.hasPermission(memberPermissions, permission.value().getPermission(), permission.acls())) continue block7;
                            return;
                        }
                        case API: {
                            ApiEntity api = this.getApi(requestContext);
                            Map memberPermissions = this.membershipService.getUserMemberPermissions(GraviteeContext.getCurrentEnvironment(), api, username);
                            if (!this.roleService.hasPermission(memberPermissions, permission.value().getPermission(), permission.acls())) continue block7;
                            return;
                        }
                        case GROUP: {
                            GroupEntity group = this.getGroup(requestContext);
                            Map memberPermissions = this.membershipService.getUserMemberPermissions(GraviteeContext.getCurrentEnvironment(), group, username);
                            if (!this.roleService.hasPermission(memberPermissions, permission.value().getPermission(), permission.acls())) continue block7;
                            return;
                        }
                        default: {
                            this.sendSecurityError();
                        }
                    }
                }
            }
            this.sendSecurityError();
        }
    }

    private ApiEntity getApi(ContainerRequestContext requestContext) {
        String apiId = this.getId("api", requestContext);
        if (apiId == null) {
            return null;
        }
        return this.apiService.findById(apiId);
    }

    private GroupEntity getGroup(ContainerRequestContext requestContext) {
        String groupId = this.getId("group", requestContext);
        if (groupId == null) {
            return null;
        }
        return this.groupService.findById(GraviteeContext.getCurrentEnvironment(), groupId);
    }

    private ApplicationEntity getApplication(ContainerRequestContext requestContext) {
        String applicationId = this.getId("application", requestContext);
        if (applicationId == null) {
            return null;
        }
        return this.applicationService.findById(GraviteeContext.getCurrentEnvironment(), applicationId);
    }

    private String getId(String key, ContainerRequestContext requestContext) {
        List pathParams = (List)requestContext.getUriInfo().getPathParameters().get((Object)key);
        if (pathParams != null) {
            return (String)pathParams.iterator().next();
        }
        List queryParams = (List)requestContext.getUriInfo().getQueryParameters().get((Object)key);
        if (queryParams != null) {
            return (String)queryParams.iterator().next();
        }
        return null;
    }

    private void sendSecurityError() {
        Principal principal = this.securityContext.getUserPrincipal();
        if (principal != null) {
            throw new ForbiddenAccessException();
        }
        throw new UnauthorizedAccessException();
    }

    private Permissions getRequiredPermission() {
        Permissions permission = this.resourceInfo.getResourceMethod().getDeclaredAnnotation(Permissions.class);
        if (permission == null) {
            return this.resourceInfo.getResourceClass().getDeclaredAnnotation(Permissions.class);
        }
        return permission;
    }
}

