/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.ServiceDiscoveryResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ResourceListItem;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.platform.plugin.PluginEntity;
import io.gravitee.rest.api.service.ServiceDiscoveryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Plugins"})
public class ServicesDiscoveryResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ServiceDiscoveryService serviceDiscoveryService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List service discovery plugins", notes="User must have the MANAGEMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of service discovery plugins", response=ResourceListItem.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public Collection<ResourceListItem> getServicesDiscoverResources(@QueryParam(value="expand") List<String> expand) {
        Stream<ResourceListItem> stream = this.serviceDiscoveryService.findAll().stream().map(this::convert);
        if (expand != null && !expand.isEmpty()) {
            Iterator<String> iterator = expand.iterator();
            while (iterator.hasNext()) {
                String s;
                switch (s = iterator.next()) {
                    case "schema": {
                        stream = stream.map(resourceListItem -> {
                            resourceListItem.setSchema(this.serviceDiscoveryService.getSchema(resourceListItem.getId()));
                            return resourceListItem;
                        });
                        break;
                    }
                }
            }
        }
        return stream.sorted(Comparator.comparing(ResourceListItem::getName)).collect(Collectors.toList());
    }

    @Path(value="{plugin}")
    public ServiceDiscoveryResource getServiceDiscoveryResource() {
        return (ServiceDiscoveryResource)this.resourceContext.getResource(ServiceDiscoveryResource.class);
    }

    private ResourceListItem convert(PluginEntity pluginEntity) {
        ResourceListItem item = new ResourceListItem();
        item.setId(pluginEntity.getId());
        item.setName(pluginEntity.getName());
        item.setDescription(pluginEntity.getDescription());
        item.setVersion(pluginEntity.getVersion());
        return item;
    }
}

