/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.NotifierResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NotifierEntity;
import io.gravitee.rest.api.model.NotifierListItem;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.NotifierService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Plugins"})
public class NotifiersResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private NotifierService notifierService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List notifier plugins", notes="User must have the MANAGEMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of notifiers", response=NotifierListItem.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public Collection<NotifierListItem> getNotifiers(@QueryParam(value="expand") List<String> expand) {
        Stream<NotifierListItem> stream = this.notifierService.findAll().stream().map(this::convert);
        if (expand != null && !expand.isEmpty()) {
            Iterator<String> iterator = expand.iterator();
            while (iterator.hasNext()) {
                String s;
                switch (s = iterator.next()) {
                    case "schema": {
                        stream = stream.map(item -> {
                            item.setSchema(this.notifierService.getSchema(item.getId()));
                            return item;
                        });
                        break;
                    }
                }
            }
        }
        return stream.sorted(Comparator.comparing(NotifierListItem::getName)).collect(Collectors.toList());
    }

    @Path(value="{notifier}")
    public NotifierResource getNotifierResource() {
        return (NotifierResource)this.resourceContext.getResource(NotifierResource.class);
    }

    private NotifierListItem convert(NotifierEntity notifier) {
        NotifierListItem item = new NotifierListItem();
        item.setId(notifier.getId());
        item.setName(notifier.getName());
        item.setDescription(notifier.getDescription());
        item.setVersion(notifier.getVersion());
        return item;
    }
}

