/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.model.FetcherEntity;
import io.gravitee.rest.api.service.FetcherService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Plugins"})
public class FetcherResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private FetcherService fetcherService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a fetcher plugin")
    @ApiResponses(value={@ApiResponse(code=200, message="Fetcher", response=FetcherEntity.class), @ApiResponse(code=404, message="Fetcher not found"), @ApiResponse(code=500, message="Internal server error")})
    public FetcherEntity getFetcher(@PathParam(value="fetcher") String fetcher) {
        return (FetcherEntity)this.fetcherService.findById(fetcher);
    }

    @GET
    @Path(value="schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a fetcher plugin's schema")
    @ApiResponses(value={@ApiResponse(code=200, message="Fetcher's schema"), @ApiResponse(code=404, message="Fetcher not found"), @ApiResponse(code=500, message="Internal server error")})
    public String getFetcherSchema(@PathParam(value="fetcher") String fetcher) {
        this.fetcherService.findById(fetcher);
        return this.fetcherService.getSchema(fetcher);
    }
}

