/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiKeyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Api(tags={"API Keys"})
public class ApiSubscriptionApiKeyResource
extends AbstractResource {
    @Inject
    private ApiKeyService apiKeyService;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;
    @PathParam(value="subscription")
    @ApiParam(name="subscription", hidden=true)
    private String subscription;
    @PathParam(value="apikey")
    @ApiParam(name="apikey", hidden=true)
    private String apikey;

    @POST
    @Path(value="/_reactivate")
    @Produces(value={"application/json"})
    @ApiOperation(value="Reactivate an API key", notes="User must have the API_SUBSCRIPTION permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="API key successfully reactivated"), @ApiResponse(code=400, message="API Key does not correspond to the subscription"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response reactivateApiKeyForApiSubscription() {
        ApiKeyEntity apiKeyEntity = this.apiKeyService.findById(this.apikey);
        if (apiKeyEntity.getSubscription() != null && !this.subscription.equals(apiKeyEntity.getSubscription())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"api key in path does not correspond to the subscription").build();
        }
        ApiKeyEntity reactivated = this.apiKeyService.reactivate(apiKeyEntity);
        return Response.ok().entity((Object)reactivated).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @ApiOperation(value="Revoke API key", notes="User must have the API_SUBSCRIPTION:DELETE permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response revokeApiKeyForApiSubscription() {
        ApiKeyEntity apiKeyEntity = this.apiKeyService.findById(this.apikey);
        if (apiKeyEntity.getSubscription() != null && !this.subscription.equals(apiKeyEntity.getSubscription())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"api key in path does not correspond to the subscription").build();
        }
        this.apiKeyService.revoke(apiKeyEntity, true);
        return Response.noContent().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update API Key", notes="User must have the API_SUBSCRIPTION:UPDATE permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API Key successfully updated", response=ApiKeyEntity.class), @ApiResponse(code=400, message="Bad API Key key format"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response updateApiKeyForApiSubscription(@Valid @NotNull ApiKeyEntity apiKey) {
        if (!this.apikey.equals(apiKey.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'apikey' parameter in path does not correspond to the api-key id to update").build();
        }
        ApiKeyEntity updatedKeyEntity = this.apiKeyService.update(apiKey);
        return Response.ok((Object)updatedKeyEntity).build();
    }
}

