/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiHeaderResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.api.header.ApiHeaderEntity;
import io.gravitee.rest.api.model.api.header.NewApiHeaderEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiHeaderService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Configuration"})
public class ApiHeadersResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ApiHeaderService apiHeaderService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List API headers")
    @ApiResponses(value={@ApiResponse(code=200, message="List of API headers", response=ApiHeaderEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API_HEADER, acls={RolePermissionAction.READ})})
    public List<ApiHeaderEntity> getApiHeaders() {
        return this.apiHeaderService.findAll(GraviteeContext.getCurrentEnvironment());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create an API header", notes="User must have the PORTAL_API_HEADER[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API header successfully created", response=ApiHeaderEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API_HEADER, acls={RolePermissionAction.CREATE})})
    public ApiHeaderEntity createApiHeader(@Valid @NotNull NewApiHeaderEntity newApiHeaderEntity) {
        return this.apiHeaderService.create(GraviteeContext.getCurrentEnvironment(), newApiHeaderEntity);
    }

    @Path(value="{id}")
    public ApiHeaderResource getApiHeaderResource() {
        return (ApiHeaderResource)this.resourceContext.getResource(ApiHeaderResource.class);
    }
}

