/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.organization.UserTokensResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PictureEntity;
import io.gravitee.rest.api.model.ResetPasswordUserEntity;
import io.gravitee.rest.api.model.UrlPictureEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.UserGroupEntity;
import io.gravitee.rest.api.model.UserMembershipList;
import io.gravitee.rest.api.model.UserReferenceRoleEntity;
import io.gravitee.rest.api.model.pagedresult.Metadata;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Api(tags={"Users"})
public class UserResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private UserService userService;
    @Inject
    private GroupService groupService;
    @PathParam(value="userId")
    @ApiParam(name="userId", required=true)
    private String userId;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a user", notes="User must have the ORGANIZATION_USERS[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="A user", response=UserEntity.class), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.READ})})
    public UserEntity getUser() {
        UserEntity user = this.userService.findByIdWithRoles(this.userId);
        user.setPassword(null);
        user.setPicture(null);
        return user;
    }

    @DELETE
    @ApiOperation(value="Delete a user", notes="User must have the ORGANIZATION_USERS[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="User successfully deleted"), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.DELETE})})
    public Response deleteUser() {
        this.userService.delete(this.userId);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/groups")
    @Produces(value={"application/json"})
    @ApiOperation(value="List of groups the user belongs to", notes="User must have the ORGANIZATION_USERS[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of user groups"), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.READ})})
    public List<UserGroupEntity> getUserGroups() {
        ArrayList<UserGroupEntity> groups = new ArrayList<UserGroupEntity>();
        this.groupService.findByUser(this.userId).forEach(groupEntity -> {
            UserGroupEntity userGroupEntity = new UserGroupEntity();
            userGroupEntity.setId(groupEntity.getId());
            userGroupEntity.setName(groupEntity.getName());
            userGroupEntity.setRoles(new HashMap());
            Set roles = this.membershipService.getRoles(MembershipReferenceType.GROUP, groupEntity.getId(), MembershipMemberType.USER, this.userId);
            if (!roles.isEmpty()) {
                roles.forEach(role -> userGroupEntity.getRoles().put(role.getScope().name(), role.getName()));
            }
            groups.add(userGroupEntity);
        });
        return groups;
    }

    @GET
    @Path(value="/memberships")
    @Produces(value={"application/json"})
    @ApiOperation(value="List of memberships the user belongs to", notes="User must have the ORGANIZATION_USERS[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of user memberships"), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.READ})})
    public UserMembershipList getUserMemberships(@QueryParam(value="type") String sType) {
        MembershipReferenceType type = null;
        if (sType != null) {
            type = MembershipReferenceType.valueOf((String)sType.toUpperCase());
        }
        List userMemberships = this.membershipService.findUserMembership(type, this.userId);
        Metadata metadata = this.membershipService.findUserMembershipMetadata(userMemberships, type);
        UserMembershipList userMembershipList = new UserMembershipList();
        userMembershipList.setMemberships(userMemberships);
        userMembershipList.setMetadata(metadata.toMap());
        return userMembershipList;
    }

    @POST
    @ApiOperation(value="Reset the user's password", notes="User must have the ORGANIZATION_USERS[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="User's password reset"), @ApiResponse(code=400, message="reset page URL must not be null"), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.UPDATE})})
    @Path(value="resetPassword")
    public Response resetUserPassword() {
        this.userService.resetPassword(this.userId);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/avatar")
    @ApiOperation(value="Get the user's avatar")
    @ApiResponses(value={@ApiResponse(code=200, message="User's avatar"), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getUserAvatar(@Context Request request) {
        PictureEntity picture = this.userService.getPicture(this.userId);
        if (picture instanceof UrlPictureEntity) {
            return Response.temporaryRedirect((URI)URI.create(((UrlPictureEntity)picture).getUrl())).build();
        }
        InlinePictureEntity image = (InlinePictureEntity)picture;
        if (image == null || image.getContent() == null) {
            return Response.ok().build();
        }
        CacheControl cc = new CacheControl();
        cc.setNoTransform(true);
        cc.setMustRevalidate(false);
        cc.setNoCache(false);
        cc.setMaxAge(86400);
        EntityTag etag = new EntityTag(Integer.toString(new String(image.getContent()).hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
        if (builder != null) {
            return builder.cacheControl(cc).build();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(image.getContent(), 0, image.getContent().length);
        return Response.ok().entity((Object)baos).cacheControl(cc).tag(etag).type(image.getType()).build();
    }

    @PUT
    @Path(value="/roles")
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.UPDATE})})
    public Response updateUserRoles(@NotNull UserReferenceRoleEntity userReferenceRoles) {
        this.userService.updateUserRoles(this.userId, userReferenceRoles.getReferenceType(), userReferenceRoles.getReferenceId(), userReferenceRoles.getRoles());
        return Response.ok().build();
    }

    @POST
    @Path(value="/changePassword")
    @ApiOperation(value="Change user password after a reset", notes="User registration must be enabled")
    @ApiResponses(value={@ApiResponse(code=200, message="User successfully updated", response=UserEntity.class), @ApiResponse(code=500, message="Internal server error")})
    public Response finalizeResetPassword(@Valid ResetPasswordUserEntity resetPwdEntity) {
        UserEntity newUser = this.userService.finalizeResetPassword(resetPwdEntity);
        if (newUser != null) {
            return Response.ok().entity((Object)newUser).build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="/_process")
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.UPDATE})})
    @ApiOperation(value="Process a user registration by accepting or rejecting it")
    @ApiResponses(value={@ApiResponse(code=200, message="Processed user"), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response validateRegistration(boolean accepted) {
        return Response.ok((Object)this.userService.processRegistration(this.userId, accepted)).build();
    }

    @Path(value="tokens")
    public UserTokensResource getUserTokensResource() {
        return (UserTokensResource)this.resourceContext.getResource(UserTokensResource.class);
    }
}

