/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.configuration.dictionary;

import io.gravitee.rest.api.management.rest.model.configuration.dictionary.DictionaryListItem;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.configuration.dictionary.DictionaryResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryEntity;
import io.gravitee.rest.api.model.configuration.dictionary.NewDictionaryEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.configuration.dictionary.DictionaryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Api(tags={"Configuration", "Dictionaries"})
public class DictionariesResource
extends AbstractResource {
    @Autowired
    private DictionaryService dictionaryService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.READ})})
    @ApiOperation(value="Get the list of global dictionaries", notes="User must have the DICTIONARY[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List global dictionaries", response=DictionaryListItem.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public List<DictionaryListItem> getDictionaries() {
        return this.dictionaryService.findAll().stream().map(dictionaryEntity -> {
            DictionaryListItem item = new DictionaryListItem();
            item.setId(dictionaryEntity.getId());
            item.setName(dictionaryEntity.getName());
            item.setDescription(dictionaryEntity.getDescription());
            item.setCreatedAt(dictionaryEntity.getCreatedAt());
            item.setUpdatedAt(dictionaryEntity.getUpdatedAt());
            item.setDeployedAt(dictionaryEntity.getDeployedAt());
            item.setType(dictionaryEntity.getType());
            item.setState(dictionaryEntity.getState());
            if (dictionaryEntity.getProperties() != null) {
                item.setProperties(dictionaryEntity.getProperties().size());
            }
            if (dictionaryEntity.getProvider() != null) {
                item.setProvider(dictionaryEntity.getProvider().getType());
            }
            return item;
        }).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.CREATE})})
    @ApiOperation(value="Create a dictionary", notes="User must have the DICTIONARY[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Dictionary successfully created", response=DictionaryEntity.class), @ApiResponse(code=500, message="Internal server error")})
    public Response createDictionary(@ApiParam(name="dictionary", required=true) @Valid @NotNull NewDictionaryEntity newDictionaryEntity) {
        DictionaryEntity newDictionary = this.dictionaryService.create(newDictionaryEntity);
        if (newDictionary != null) {
            return Response.created((URI)this.getLocationHeader(newDictionary.getId())).entity((Object)newDictionary).build();
        }
        return Response.serverError().build();
    }

    @Path(value="{dictionary}")
    public DictionaryResource getDictionaryResource() {
        return (DictionaryResource)this.resourceContext.getResource(DictionaryResource.class);
    }
}

