/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NewTopApiEntity;
import io.gravitee.rest.api.model.TopApiEntity;
import io.gravitee.rest.api.model.UpdateTopApiEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.TopApiService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriBuilder;

@Api(tags={"Top APIs"})
public class TopApisResource
extends AbstractResource {
    @Inject
    private TopApiService topApiService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List of top APIs", notes="User must have the PORTAL_TOP_APIS[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of top APIs", response=TopApiEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TOP_APIS, acls={RolePermissionAction.READ})})
    public List<TopApiEntity> getTopApis() {
        return this.topApiService.findAll().stream().peek(this.addPictureUrl()).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a top API", notes="User must have the PORTAL_TOP_APIS[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of top APIs", response=TopApiEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TOP_APIS, acls={RolePermissionAction.CREATE})})
    public List<TopApiEntity> createTopApi(@Valid @NotNull NewTopApiEntity topApi) {
        return this.topApiService.create(topApi).stream().peek(this.addPictureUrl()).collect(Collectors.toList());
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a top API", notes="User must have the PORTAL_TOP_APIS[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of top APIs", response=TopApiEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TOP_APIS, acls={RolePermissionAction.UPDATE})})
    public List<TopApiEntity> updateTopApi(@Valid @NotNull List<UpdateTopApiEntity> topApis) {
        return this.topApiService.update(topApis).stream().peek(this.addPictureUrl()).collect(Collectors.toList());
    }

    @Path(value="{topAPI}")
    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Delete an existing top API", notes="User must have the PORTAL_TOP_APIS[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Top API successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TOP_APIS, acls={RolePermissionAction.DELETE})})
    public void deleteTopApi(@PathParam(value="topAPI") String topAPI) {
        this.topApiService.delete(topAPI);
    }

    private Consumer<TopApiEntity> addPictureUrl() {
        return topApiEntity -> {
            UriBuilder ub = this.uriInfo.getBaseUriBuilder();
            UriBuilder uriBuilder = ub.path("organizations").path(GraviteeContext.getCurrentOrganization()).path("environments").path(GraviteeContext.getCurrentEnvironment()).path("apis").path(topApiEntity.getApi()).path("picture");
            topApiEntity.setPictureUrl(uriBuilder.build(new Object[0]).toString());
        };
    }
}

