/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Group Memberships"})
public class GroupMemberResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private GroupService groupService;
    @PathParam(value="group")
    @ApiParam(name="group", hidden=true)
    private String group;

    @DELETE
    @ApiOperation(value="Remove a group member")
    @ApiResponses(value={@ApiResponse(code=200, message="Member has been removed successfully"), @ApiResponse(code=400, message="User does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.DELETE}), @Permission(value=RolePermission.GROUP_MEMBER, acls={RolePermissionAction.DELETE})})
    public Response deleteGroupMember(@PathParam(value="member") String userId) {
        this.groupService.deleteUserFromGroup(GraviteeContext.getCurrentEnvironment(), this.group, userId);
        return Response.ok().build();
    }
}

