/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.OrganizationFlowConfiguration;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Api(tags={"Flows"})
public class FlowsResource
extends AbstractResource {
    @Inject
    private FlowService flowService;
    @Inject
    private OrganizationService organizationService;
    @PathParam(value="orgId")
    @ApiParam(name="orgId", hidden=true)
    private String orgId;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the global flow configuration of the organization")
    @ApiResponses(value={@ApiResponse(code=200, message="Platform flows configuration", response=OrganizationFlowConfiguration.class), @ApiResponse(code=500, message="Internal server error")})
    public Response hasPolicies() {
        boolean hasPlatformPolicies = !this.organizationService.findById(this.orgId).getFlows().isEmpty();
        OrganizationFlowConfiguration flowConfiguration = new OrganizationFlowConfiguration();
        flowConfiguration.setHasPolicies(hasPlatformPolicies);
        return Response.ok((Object)flowConfiguration).build();
    }

    @GET
    @Path(value="configuration-schema")
    @Produces(value={"application/json"})
    public Response getConfigurationSchemaForm() {
        return Response.ok((Object)this.flowService.getConfigurationSchemaForm()).build();
    }

    @GET
    @Path(value="flow-schema")
    @Produces(value={"application/json"})
    public Response getPlatformFlowSchemaForm() {
        return Response.ok((Object)this.flowService.getPlatformFlowSchemaForm()).build();
    }
}

