/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.ConnectorResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ConnectorListItem;
import io.gravitee.rest.api.model.ConnectorPluginEntity;
import io.gravitee.rest.api.model.ResourceListItem;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ConnectorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Plugins"})
public class ConnectorsResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ConnectorService connectorService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List connector plugins", notes="User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of connectors", response=ResourceListItem.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public Collection<ConnectorListItem> getConnectors(@QueryParam(value="expand") List<String> expand) {
        Stream<ConnectorListItem> stream = this.connectorService.findAll().stream().map(this::convert);
        if (expand != null && !expand.isEmpty()) {
            Iterator<String> iterator = expand.iterator();
            while (iterator.hasNext()) {
                String s;
                switch (s = iterator.next()) {
                    case "schema": {
                        stream = stream.peek(connectorListItem -> connectorListItem.setSchema(this.connectorService.getSchema(connectorListItem.getId())));
                    }
                    case "icon": {
                        stream = stream.peek(connectorListItem -> connectorListItem.setIcon(this.connectorService.getIcon(connectorListItem.getId())));
                    }
                }
            }
        }
        return stream.sorted(Comparator.comparing(ConnectorListItem::getName)).collect(Collectors.toList());
    }

    @Path(value="{connector}")
    public ConnectorResource getConnectorResource() {
        return (ConnectorResource)this.resourceContext.getResource(ConnectorResource.class);
    }

    private ConnectorListItem convert(ConnectorPluginEntity connector) {
        ConnectorListItem item = new ConnectorListItem();
        item.setId(connector.getId());
        item.setName(connector.getName());
        item.setDescription(connector.getDescription());
        item.setVersion(connector.getVersion());
        item.setSupportedTypes(connector.getSupportedTypes());
        return item;
    }
}

