/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.data.domain.Page;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.rest.api.management.rest.model.Pageable;
import io.gravitee.rest.api.management.rest.model.PagedResult;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiMediaResource;
import io.gravitee.rest.api.management.rest.resource.ApiResource;
import io.gravitee.rest.api.management.rest.resource.ApisOrderParam;
import io.gravitee.rest.api.management.rest.resource.param.ApisParam;
import io.gravitee.rest.api.management.rest.resource.param.VerifyApiParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.RatingSummaryEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.api.ApiListItem;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.api.NewApiEntity;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.common.SortableImpl;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.RatingService;
import io.gravitee.rest.api.service.SwaggerService;
import io.gravitee.rest.api.service.TopApiService;
import io.gravitee.rest.api.service.VirtualHostService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import io.gravitee.rest.api.service.exceptions.ApiAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.Hook;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

@Api(tags={"APIs"})
public class ApisResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ApiService apiService;
    @Inject
    private SwaggerService swaggerService;
    @Inject
    private TopApiService topApiService;
    @Inject
    private RatingService ratingService;
    @Inject
    private VirtualHostService virtualHostService;
    @Inject
    private CategoryService categoryService;
    @Inject
    private FlowService flowService;
    @Inject
    protected ApiDuplicatorService apiDuplicatorService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List APIs", notes="List all the APIs accessible to the current user.")
    @ApiResponses(value={@ApiResponse(code=200, message="List accessible APIs for current user", response=ApiListItem.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public Collection<ApiListItem> getApis(@BeanParam ApisParam apisParam) {
        return this.getApis(apisParam, null).getData();
    }

    @GET
    @Path(value="_paged")
    @Produces(value={"application/json"})
    @ApiOperation(value="List APIs with pagination", notes="List all the APIs accessible to the current user with pagination.", nickname="getApisPaged")
    @ApiResponses(value={@ApiResponse(code=200, message="Page of APIs for current user", response=PagedResult.class), @ApiResponse(code=500, message="Internal server error")})
    public PagedResult<ApiListItem> getApis(@BeanParam ApisParam apisParam, @Valid @BeanParam Pageable pageable) {
        Page apis;
        ApiQuery apiQuery = new ApiQuery();
        if (apisParam.getGroup() != null) {
            apiQuery.setGroups(Collections.singletonList(apisParam.getGroup()));
        }
        apiQuery.setContextPath(apisParam.getContextPath());
        apiQuery.setLabel(apisParam.getLabel());
        apiQuery.setVersion(apisParam.getVersion());
        apiQuery.setName(apisParam.getName());
        apiQuery.setTag(apisParam.getTag());
        apiQuery.setState(apisParam.getState());
        if (apisParam.getCategory() != null) {
            apiQuery.setCategory(this.categoryService.findById(apisParam.getCategory(), GraviteeContext.getCurrentEnvironment()).getId());
        }
        SortableImpl sortable = null;
        if (apisParam.getOrder() != null) {
            sortable = new SortableImpl(apisParam.getOrder().getField(), apisParam.getOrder().isOrder());
        }
        io.gravitee.rest.api.model.common.Pageable commonPageable = null;
        if (pageable != null) {
            commonPageable = pageable.toPageable();
        }
        if (this.isAdmin()) {
            apis = this.apiService.search(apiQuery, (Sortable)sortable, commonPageable);
        } else {
            if (apisParam.isPortal() || apisParam.isTop()) {
                apiQuery.setLifecycleStates(Collections.singletonList(ApiLifecycleState.PUBLISHED));
            }
            if (this.isAuthenticated()) {
                apis = this.apiService.findByUser(this.getAuthenticatedUser(), apiQuery, (Sortable)sortable, commonPageable, apisParam.isPortal());
            } else {
                apiQuery.setVisibility(Visibility.PUBLIC);
                apis = this.apiService.search(apiQuery, (Sortable)sortable, commonPageable);
            }
        }
        boolean isRatingServiceEnabled = this.ratingService.isEnabled();
        if (apisParam.isTop()) {
            List visibleApis = apis.getContent().stream().map(ApiEntity::getId).collect(Collectors.toList());
            return new PagedResult<ApiListItem>(this.topApiService.findAll().stream().filter(topApi -> visibleApis.contains(topApi.getApi())).map(topApiEntity -> this.apiService.findById(topApiEntity.getApi())).map(apiEntity -> this.convert((ApiEntity)apiEntity, isRatingServiceEnabled)).collect(Collectors.toList()), apis.getPageNumber(), (int)apis.getPageElements(), (int)apis.getTotalElements());
        }
        return new PagedResult<ApiListItem>(apis.getContent().stream().map(apiEntity -> this.convert((ApiEntity)apiEntity, isRatingServiceEnabled)).collect(Collectors.toList()), apis.getPageNumber(), (int)apis.getPageElements(), (int)apis.getTotalElements());
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Create an API", notes="User must have API_PUBLISHER or ADMIN role to create an API.")
    @ApiResponses(value={@ApiResponse(code=201, message="API successfully created"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE})})
    public Response createApi(@ApiParam(name="api", required=true) @Valid @NotNull NewApiEntity newApiEntity) throws ApiAlreadyExistsException {
        ApiEntity newApi = this.apiService.create(newApiEntity, this.getAuthenticatedUser());
        if (newApi != null) {
            return Response.created((URI)this.getLocationHeader(newApi.getId())).entity((Object)newApi).build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="import")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create an API by importing an API definition", notes="Create an API by importing an existing API definition in JSON format")
    @ApiResponses(value={@ApiResponse(code=200, message="API successfully created"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.UPDATE})})
    public Response importApiDefinition(@ApiParam(name="definition", required=true) @Valid @NotNull String apiDefinition, @QueryParam(value="definitionVersion") @DefaultValue(value="1.0.0") String definitionVersion) {
        ApiEntity imported = this.apiDuplicatorService.createWithImportedDefinition(apiDefinition, this.getAuthenticatedUser(), GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment());
        if (DefinitionVersion.valueOfLabel((String)definitionVersion).equals((Object)DefinitionVersion.V2) && DefinitionVersion.V1.getLabel().equals(imported.getGraviteeDefinitionVersion())) {
            return Response.ok((Object)this.apiService.migrate(imported.getId())).build();
        }
        return Response.ok((Object)imported).build();
    }

    @POST
    @Path(value="import/swagger")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create an API definition from a Swagger descriptor")
    @ApiResponses(value={@ApiResponse(code=201, message="API definition from Swagger descriptor", response=ApiEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE})})
    public Response importSwaggerApi(@ApiParam(name="swagger", required=true) @Valid @NotNull ImportSwaggerDescriptorEntity swaggerDescriptor, @QueryParam(value="definitionVersion") @DefaultValue(value="1.0.0") String definitionVersion) {
        SwaggerApiEntity swaggerApiEntity = this.swaggerService.createAPI(swaggerDescriptor, DefinitionVersion.valueOfLabel((String)definitionVersion));
        ApiEntity api = this.apiService.createFromSwagger(swaggerApiEntity, this.getAuthenticatedUser(), swaggerDescriptor);
        return Response.created((URI)URI.create(this.uriInfo.getRequestUri().getRawPath().replaceAll("import/swagger", "") + api.getId())).entity((Object)api).build();
    }

    @POST
    @Path(value="verify")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Check if an API match the following criteria")
    @ApiResponses(value={@ApiResponse(code=200, message="No API match the following criteria"), @ApiResponse(code=400, message="API already exist with the following criteria")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE})})
    public Response verifyApi(@Valid VerifyApiParam verifyApiParam) {
        this.virtualHostService.sanitizeAndValidate(Collections.singletonList(new VirtualHost(verifyApiParam.getContextPath())));
        return Response.ok().entity((Object)("API context [" + verifyApiParam.getContextPath() + "] is available")).build();
    }

    @GET
    @Path(value="/hooks")
    @ApiOperation(value="Get the list of available hooks")
    @Produces(value={"application/json"})
    public Hook[] getApiHooks() {
        return (Hook[])Arrays.stream(ApiHook.values()).filter(h -> !h.isHidden()).toArray(Hook[]::new);
    }

    @POST
    @Path(value="_search")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search for API using the search engine")
    @ApiResponses(value={@ApiResponse(code=200, message="List accessible APIs for current user", response=ApiListItem.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public Response searchApis(@ApiParam(name="q", required=true) @NotNull @QueryParam(value="q") String query) {
        try {
            return Response.ok().entity(this.searchApis(query, new ApisOrderParam("name"), null).getData()).build();
        }
        catch (TechnicalManagementException te) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)te).build();
        }
    }

    @POST
    @Path(value="_search/_paged")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search for API using the search engine")
    @ApiResponses(value={@ApiResponse(code=200, message="List accessible APIs for current user", response=ApiListItem.class), @ApiResponse(code=500, message="Internal server error")})
    public PagedResult<ApiListItem> searchApis(@ApiParam(name="q", required=true) @NotNull @QueryParam(value="q") String query, @ApiParam(name="order") @QueryParam(value="order") @DefaultValue(value="name") ApisOrderParam apisOrderParam, @Valid @BeanParam Pageable pageable) {
        ApiQuery apiQuery = new ApiQuery();
        HashMap<String, Set> filters = new HashMap<String, Set>();
        io.gravitee.rest.api.model.common.Pageable commonPageable = null;
        if (pageable != null) {
            commonPageable = pageable.toPageable();
        }
        if (!this.isAdmin()) {
            filters.put("api", this.apiService.findIdsByUser(this.getAuthenticatedUser(), apiQuery, false));
        }
        boolean isRatingServiceEnabled = this.ratingService.isEnabled();
        Page apis = this.apiService.search(query, filters, apisOrderParam.toSortable(), commonPageable);
        return new PagedResult<ApiListItem>(apis.getContent().stream().map(apiEntity -> this.convert((ApiEntity)apiEntity, isRatingServiceEnabled)).collect(Collectors.toList()), apis.getPageNumber(), (int)apis.getPageElements(), (int)apis.getTotalElements());
    }

    @Path(value="{api}")
    public ApiResource getApiResource() {
        return (ApiResource)this.resourceContext.getResource(ApiResource.class);
    }

    @Path(value="{api}/media")
    public ApiMediaResource getApiMediaResource() {
        return (ApiMediaResource)this.resourceContext.getResource(ApiMediaResource.class);
    }

    private ApiListItem convert(ApiEntity api, boolean isRatingServiceEnabled) {
        ApiListItem apiItem = new ApiListItem();
        apiItem.setId(api.getId());
        apiItem.setName(api.getName());
        apiItem.setVersion(api.getVersion());
        apiItem.setDescription(api.getDescription());
        UriBuilder ub = this.uriInfo.getBaseUriBuilder();
        UriBuilder uriBuilder = ub.path("organizations").path(GraviteeContext.getCurrentOrganization()).path("environments").path(GraviteeContext.getCurrentEnvironment()).path("apis").path(api.getId()).path("picture");
        uriBuilder.queryParam("hash", new Object[]{api.getUpdatedAt().getTime()});
        apiItem.setPictureUrl(uriBuilder.build(new Object[0]).toString());
        apiItem.setCategories(api.getCategories());
        apiItem.setCreatedAt(api.getCreatedAt());
        apiItem.setUpdatedAt(api.getUpdatedAt());
        apiItem.setLabels(api.getLabels());
        apiItem.setPrimaryOwner(api.getPrimaryOwner());
        apiItem.setHasHealthCheckEnabled(this.apiService.hasHealthCheckEnabled(api, false));
        if (api.getVisibility() != null) {
            apiItem.setVisibility(Visibility.valueOf((String)api.getVisibility().toString()));
        }
        if (api.getState() != null) {
            apiItem.setState(Lifecycle.State.valueOf((String)api.getState().toString()));
        }
        if (api.getProxy() != null) {
            apiItem.setVirtualHosts(api.getProxy().getVirtualHosts());
        }
        if (isRatingServiceEnabled) {
            RatingSummaryEntity ratingSummary = this.ratingService.findSummaryByApi(api.getId());
            apiItem.setRate(ratingSummary.getAverageRate());
            apiItem.setNumberOfRatings(ratingSummary.getNumberOfRatings());
        }
        apiItem.setTags(api.getTags());
        if (api.getLifecycleState() != null) {
            apiItem.setLifecycleState(ApiLifecycleState.valueOf((String)api.getLifecycleState().toString()));
        }
        if (api.getWorkflowState() != null) {
            apiItem.setWorkflowState(WorkflowState.valueOf((String)api.getWorkflowState().toString()));
        }
        if (api.getProxy().getVirtualHosts() != null && !api.getProxy().getVirtualHosts().isEmpty()) {
            apiItem.setContextPath(((VirtualHost)api.getProxy().getVirtualHosts().get(0)).getPath());
        }
        return apiItem;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="schema")
    @ApiOperation(value="Get the API configuration schema")
    @ApiResponses(value={@ApiResponse(code=200, message="API definition"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public Response getApiFlowSchemaForm() {
        return Response.ok((Object)this.flowService.getApiFlowSchemaForm()).build();
    }
}

