/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.Subscription;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscriptionApiKeysResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.ProcessSubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.TransferSubscriptionEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"API Subscriptions"})
public class ApiSubscriptionResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private ApiKeyService apiKeyService;
    @Inject
    private PlanService planService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private UserService userService;
    @Inject
    private ParameterService parameterService;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a subscription", notes="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Get a subscription", response=Subscription.class), @ApiResponse(code=404, message="Subscription does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public Subscription getApiSubscription(@PathParam(value="subscription") String subscription) {
        return this.convert(this.subscriptionService.findById(subscription));
    }

    @POST
    @Path(value="/_process")
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a subscription", notes="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Update a subscription", response=Subscription.class), @ApiResponse(code=400, message="Bad subscription format"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response processApiSubscription(@PathParam(value="subscription") String subscription, @ApiParam(name="subscription", required=true) @Valid @NotNull ProcessSubscriptionEntity processSubscriptionEntity) {
        if (processSubscriptionEntity.getId() != null && !subscription.equals(processSubscriptionEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'subscription' parameter does not correspond to the subscription to process").build();
        }
        processSubscriptionEntity.setId(subscription);
        SubscriptionEntity subscriptionEntity = this.subscriptionService.process(processSubscriptionEntity, this.getAuthenticatedUser());
        return Response.ok((Object)this.convert(subscriptionEntity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a subscription", notes="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Update a subscription", response=Subscription.class), @ApiResponse(code=400, message="Bad subscription format"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response updateApiSubscription(@PathParam(value="subscription") String subscription, @ApiParam(name="subscription", required=true) @Valid @NotNull UpdateSubscriptionEntity updateSubscriptionEntity) {
        if (updateSubscriptionEntity.getId() != null && !subscription.equals(updateSubscriptionEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'subscription' parameter does not correspond to the subscription to update").build();
        }
        updateSubscriptionEntity.setId(subscription);
        SubscriptionEntity subscriptionEntity = this.subscriptionService.update(updateSubscriptionEntity);
        return Response.ok((Object)this.convert(subscriptionEntity)).build();
    }

    @POST
    @Path(value="/status")
    @Produces(value={"application/json"})
    @ApiOperation(value="Change the status of a subscription", notes="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Subscription status successfully updated", response=Subscription.class), @ApiResponse(code=400, message="Status changes not authorized"), @ApiResponse(code=404, message="API subscription does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response changeApiSubscriptionStatus(@PathParam(value="subscription") String subscription, @ApiParam(required=true, allowableValues="CLOSED, PAUSED, RESUMED") @QueryParam(value="status") SubscriptionStatus subscriptionStatus) {
        if (SubscriptionStatus.CLOSED.equals((Object)subscriptionStatus)) {
            SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.close(subscription);
            return Response.ok((Object)this.convert(updatedSubscriptionEntity)).build();
        }
        if (SubscriptionStatus.PAUSED.equals((Object)subscriptionStatus)) {
            SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.pause(subscription);
            return Response.ok((Object)this.convert(updatedSubscriptionEntity)).build();
        }
        if (SubscriptionStatus.RESUMED.equals((Object)subscriptionStatus)) {
            SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.resume(subscription);
            return Response.ok((Object)this.convert(updatedSubscriptionEntity)).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @POST
    @Path(value="/_transfer")
    @Produces(value={"application/json"})
    @ApiOperation(value="Transfer a subscription", notes="User must have the API_SUBSCRIPTION update permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Update a subscription", response=Subscription.class), @ApiResponse(code=400, message="Bad subscription format"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response transferApiSubscription(@PathParam(value="subscription") String subscription, @ApiParam(name="subscription", required=true) @Valid @NotNull TransferSubscriptionEntity transferSubscriptionEntity) {
        if (transferSubscriptionEntity.getId() != null && !subscription.equals(transferSubscriptionEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'subscription' parameter does not correspond to the subscription to process").build();
        }
        transferSubscriptionEntity.setId(subscription);
        SubscriptionEntity subscriptionEntity = this.subscriptionService.transfer(transferSubscriptionEntity, this.getAuthenticatedUser());
        return Response.ok((Object)this.convert(subscriptionEntity)).build();
    }

    private Subscription convert(SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(subscriptionEntity.getCreatedAt());
        subscription.setUpdatedAt(subscriptionEntity.getUpdatedAt());
        subscription.setStartingAt(subscriptionEntity.getStartingAt());
        subscription.setEndingAt(subscriptionEntity.getEndingAt());
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt());
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setRequest(subscriptionEntity.getRequest());
        subscription.setReason(subscriptionEntity.getReason());
        subscription.setRequest(subscriptionEntity.getRequest());
        subscription.setStatus(subscriptionEntity.getStatus());
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), this.userService.findById(subscriptionEntity.getSubscribedBy(), true).getDisplayName()));
        subscription.setClientId(subscriptionEntity.getClientId());
        PlanEntity plan = this.planService.findById(subscriptionEntity.getPlan());
        subscription.setPlan(new Subscription.Plan(plan.getId(), plan.getName()));
        subscription.getPlan().setSecurity(plan.getSecurity());
        ApplicationEntity application = this.applicationService.findById(GraviteeContext.getCurrentEnvironment(), subscriptionEntity.getApplication());
        subscription.setApplication(new Subscription.Application(application.getId(), application.getName(), application.getType(), application.getDescription(), application.getDomain(), new Subscription.User(application.getPrimaryOwner().getId(), application.getPrimaryOwner().getDisplayName())));
        subscription.setClosedAt(subscriptionEntity.getClosedAt());
        subscription.setPausedAt(subscriptionEntity.getPausedAt());
        return subscription;
    }

    @Path(value="apikeys")
    public ApiSubscriptionApiKeysResource getApiSubscriptionApiKeysResourceResource() {
        return (ApiSubscriptionApiKeysResource)this.resourceContext.getResource(ApiSubscriptionApiKeysResource.class);
    }
}

