/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.model.RoleMembership;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.organization.RoleUserResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MembershipListItem;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Roles"})
public class RoleUsersResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private MembershipService membershipService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List users with the given role", notes="User must have the MANAGEMENT_ROLE[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="List of user's memberships", response=MembershipListItem.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.READ})})
    public List<MembershipListItem> getUsersPerRole(@PathParam(value="scope") RoleScope scope, @PathParam(value="role") String role) {
        Optional optRole;
        if (RoleScope.ORGANIZATION.equals((Object)scope) && (optRole = this.roleService.findByScopeAndName(scope, role)).isPresent()) {
            Set members = this.membershipService.getMembersByReferenceAndRole(MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization(), ((RoleEntity)optRole.get()).getId());
            return members.stream().filter(Objects::nonNull).map(MembershipListItem::new).sorted((a, b) -> {
                if (a.getDisplayName() == null && b.getDisplayName() == null) {
                    return a.getId().compareToIgnoreCase(b.getId());
                }
                if (a.getDisplayName() == null) {
                    return -1;
                }
                if (b.getDisplayName() == null) {
                    return 1;
                }
                return a.getDisplayName().compareToIgnoreCase(b.getDisplayName());
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Add or update a role for a user", notes="User must have the MANAGEMENT_ROLE[CREATE] and MANAGEMENT_ROLE[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Membership successfully created / updated"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.UPDATE})})
    public Response addRoleToUser(@ApiParam(name="scope", required=true, allowableValues="ORGANIZATION,ENVIRONMENT") @PathParam(value="scope") RoleScope roleScope, @PathParam(value="role") String roleName, @Valid @NotNull RoleMembership roleMembership) {
        if (roleScope == null || roleName == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Role must be set").build();
        }
        Object referenceType = null;
        Object referenceId = null;
        if (!RoleScope.ORGANIZATION.equals((Object)roleScope)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Can't determine context").build();
        }
        this.membershipService.addRoleToMemberOnReference(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment(), new MembershipService.MembershipReference(MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization()), new MembershipService.MembershipMember(roleMembership.getId(), roleMembership.getReference(), MembershipMemberType.USER), new MembershipService.MembershipRole(roleScope, roleName));
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @Path(value="{userId}")
    public RoleUserResource getRoleUserResource() {
        return (RoleUserResource)this.resourceContext.getResource(RoleUserResource.class);
    }
}

