/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PathParam;

@Api(tags={"Roles"})
public class RoleUserResource
extends AbstractResource {
    @Inject
    private MembershipService membershipService;

    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Delete the role for a given user", notes="User must have the MANAGEMENT_ROLE[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Role successfully removed"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.DELETE})})
    public void deleteRoleForUsert(@PathParam(value="scope") RoleScope scope, @PathParam(value="role") String role, @PathParam(value="userId") String userId) {
        Optional roleToRemove = this.roleService.findByScopeAndName(scope, role);
        if (roleToRemove.isPresent()) {
            String roleId = ((RoleEntity)roleToRemove.get()).getId();
            if (RoleScope.ORGANIZATION.equals((Object)scope)) {
                this.membershipService.removeRole(MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization(), MembershipMemberType.USER, userId, roleId);
            }
        }
    }
}

