/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.organization.RoleScopeResource;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.ApplicationPermission;
import io.gravitee.rest.api.model.permissions.EnvironmentPermission;
import io.gravitee.rest.api.model.permissions.OrganizationPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Roles"})
public class RoleScopesResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List availables role scopes")
    @ApiResponses(value={@ApiResponse(code=200, message="List of role scopes"), @ApiResponse(code=500, message="Internal server error")})
    public Map<String, List<String>> getRoleScopes() {
        LinkedHashMap<String, List<String>> roles = new LinkedHashMap<String, List<String>>(4);
        roles.put(RoleScope.ORGANIZATION.name(), Arrays.stream(OrganizationPermission.values()).map(OrganizationPermission::getName).sorted().collect(Collectors.toList()));
        roles.put(RoleScope.ENVIRONMENT.name(), Arrays.stream(EnvironmentPermission.values()).map(EnvironmentPermission::getName).sorted().collect(Collectors.toList()));
        roles.put(RoleScope.API.name(), Arrays.stream(ApiPermission.values()).map(ApiPermission::getName).sorted().collect(Collectors.toList()));
        roles.put(RoleScope.APPLICATION.name(), Arrays.stream(ApplicationPermission.values()).map(ApplicationPermission::getName).sorted().collect(Collectors.toList()));
        return roles;
    }

    @Path(value="{scope}/roles")
    public RoleScopeResource getRoleScopeResource() {
        return (RoleScopeResource)this.resourceContext.getResource(RoleScopeResource.class);
    }
}

