/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.management.model.Event;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.EventSearchParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;

@Api(tags={"Platform Events"})
public class PlatformEventsResource
extends AbstractResource {
    @Inject
    private EventService eventService;
    @Inject
    private ApiService apiService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List platform events", notes="User must have the MANAGEMENT_PLATFORM[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Platform events", response=EventEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_PLATFORM, acls={RolePermissionAction.READ})})
    public Page<EventEntity> getPlatformEvents(@BeanParam EventSearchParam eventSearchParam) {
        eventSearchParam.validate();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (eventSearchParam.getApiIdsParam() != null && eventSearchParam.getApiIdsParam().getIds() != null && !eventSearchParam.getApiIdsParam().getIds().isEmpty()) {
            properties.put(Event.EventProperties.API_ID.getValue(), eventSearchParam.getApiIdsParam().getIds());
        } else if (!this.isAdmin()) {
            properties.put(Event.EventProperties.API_ID.getValue(), this.apiService.findByUser(this.getAuthenticatedUser(), null, false).stream().filter(api -> this.permissionService.hasPermission(RolePermission.API_ANALYTICS, api.getId(), new RolePermissionAction[]{RolePermissionAction.READ})).map(ApiEntity::getId).collect(Collectors.joining(",")));
        }
        Page events = this.eventService.search(eventSearchParam.getEventTypeListParam().getEventTypes(), properties, eventSearchParam.getFrom().longValue(), eventSearchParam.getTo().longValue(), eventSearchParam.getPage().intValue(), eventSearchParam.getSize().intValue(), Collections.singletonList(GraviteeContext.getCurrentEnvironment()));
        events.getContent().forEach(event -> {
            Map properties1 = event.getProperties();
            if (properties1 != null && properties1.containsKey(Event.EventProperties.API_ID.getValue())) {
                event.setPayload(null);
                String apiId = (String)properties1.get(Event.EventProperties.API_ID.getValue());
                try {
                    ApiEntity api = this.apiService.findById(apiId);
                    properties1.put("api_name", api.getName());
                    properties1.put("api_version", api.getVersion());
                }
                catch (ApiNotFoundException anfe) {
                    properties1.put("deleted", Boolean.TRUE.toString());
                    properties1.put("api_name", "Deleted API");
                }
            }
        });
        return events;
    }
}

