/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.InvitationEntity;
import io.gravitee.rest.api.model.InvitationReferenceType;
import io.gravitee.rest.api.model.NewInvitationEntity;
import io.gravitee.rest.api.model.UpdateInvitationEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.InvitationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.GroupInvitationForbiddenException;
import io.gravitee.rest.api.service.exceptions.GroupMembersLimitationExceededException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Api(tags={"Group Invitations"})
public class GroupInvitationsResource
extends AbstractResource {
    @Inject
    private InvitationService invitationService;
    @Inject
    private GroupService groupService;
    @PathParam(value="group")
    @ApiParam(name="group", hidden=true)
    private String group;

    @GET
    @ApiOperation(value="List existing invitations of a group", notes="User must have the GROUP_INVITATION[READ] permission to use this service")
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ, RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE}), @Permission(value=RolePermission.GROUP_INVITATION, acls={RolePermissionAction.READ})})
    public List<InvitationEntity> getGroupInvitations() {
        return this.invitationService.findByReference(InvitationReferenceType.GROUP, this.group);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create an invitation to join a group", notes="User must have the GROUP_INVITATION[CREATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE, RolePermissionAction.CREATE}), @Permission(value=RolePermission.GROUP_INVITATION, acls={RolePermissionAction.CREATE})})
    public InvitationEntity createGroupInvitation(@Valid @NotNull NewInvitationEntity invitationEntity) {
        GroupEntity groupEntity = this.groupService.findById(GraviteeContext.getCurrentEnvironment(), this.group);
        boolean hasPermission = this.permissionService.hasPermission(RolePermission.ENVIRONMENT_GROUP, GraviteeContext.getCurrentEnvironment(), new RolePermissionAction[]{RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE});
        if (!hasPermission) {
            if (groupEntity.getMaxInvitation() != null && this.groupService.getNumberOfMembers(this.group) >= groupEntity.getMaxInvitation()) {
                throw new GroupMembersLimitationExceededException(groupEntity.getMaxInvitation().intValue());
            }
            if (!groupEntity.isEmailInvitation()) {
                throw new GroupInvitationForbiddenException(GroupInvitationForbiddenException.Type.EMAIL, this.group);
            }
        }
        invitationEntity.setReferenceType(InvitationReferenceType.GROUP);
        invitationEntity.setReferenceId(this.group);
        return this.invitationService.create(invitationEntity);
    }

    @Path(value="{invitation}")
    @PUT
    @ApiOperation(value="Update an invitation to join a group", notes="User must have the GROUP_INVITATION[UPDATE] permission to use this service")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE, RolePermissionAction.CREATE}), @Permission(value=RolePermission.GROUP_INVITATION, acls={RolePermissionAction.UPDATE})})
    public InvitationEntity updateGroupInvitation(@PathParam(value="invitation") String invitation, @Valid @NotNull UpdateInvitationEntity invitationEntity) {
        invitationEntity.setId(invitation);
        invitationEntity.setReferenceType(InvitationReferenceType.GROUP);
        invitationEntity.setReferenceId(this.group);
        return this.invitationService.update(invitationEntity);
    }

    @Path(value="{invitation}")
    @DELETE
    @ApiOperation(value="Delete an invitation to join a group", notes="User must have the GROUP_INVITATION[DELETE] permission to use this service")
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE, RolePermissionAction.CREATE}), @Permission(value=RolePermission.GROUP_INVITATION, acls={RolePermissionAction.DELETE})})
    public void deleteGroupInvitation(@PathParam(value="invitation") String invitation) {
        this.invitationService.delete(invitation, this.group);
    }
}

