/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.EntrypointEntity;
import io.gravitee.rest.api.model.EntrypointReferenceType;
import io.gravitee.rest.api.model.NewEntryPointEntity;
import io.gravitee.rest.api.model.UpdateEntryPointEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.EntrypointService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Api(tags={"Entrypoints"})
public class EntrypointsResource
extends AbstractResource {
    @Inject
    private EntrypointService entrypointService;

    @GET
    @Path(value="{entrypoint}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a platform entrypoints", notes="User must have the MANAGEMENT_ENTRYPOINT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="A platform entrypoint", response=EntrypointEntity.class), @ApiResponse(code=404, message="Entrypoint not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ENTRYPOINT, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.ORGANIZATION_ENTRYPOINT, acls={RolePermissionAction.READ})})
    public EntrypointEntity getEntrypoint(@PathParam(value="entrypoint") String entrypointId) {
        return this.entrypointService.findByIdAndReference(entrypointId, GraviteeContext.getCurrentOrganization(), EntrypointReferenceType.ORGANIZATION);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List the platform entrypoints", notes="User must have the MANAGEMENT_ENTRYPOINT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of platform entrypoints", response=EntrypointEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ENTRYPOINT, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.ORGANIZATION_ENTRYPOINT, acls={RolePermissionAction.READ})})
    public List<EntrypointEntity> getEntrypoints() {
        return this.entrypointService.findByReference(GraviteeContext.getCurrentOrganization(), EntrypointReferenceType.ORGANIZATION).stream().sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getValue(), o2.getValue())).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a platform entrypoint", notes="User must have the MANAGEMENT_ENTRYPOINT[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Entrypoint successfully created", response=EntrypointEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ENTRYPOINT, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ORGANIZATION_ENTRYPOINT, acls={RolePermissionAction.CREATE})})
    public EntrypointEntity createEntrypoint(@Valid @NotNull NewEntryPointEntity entrypoint) {
        return this.entrypointService.create(entrypoint, GraviteeContext.getCurrentOrganization(), EntrypointReferenceType.ORGANIZATION);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a platform entrypoint", notes="User must have the MANAGEMENT_ENTRYPOINT[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated entrypoint", response=EntrypointEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ENTRYPOINT, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.ORGANIZATION_ENTRYPOINT, acls={RolePermissionAction.UPDATE})})
    public EntrypointEntity updateEntrypoint(@Valid @NotNull UpdateEntryPointEntity entrypoint) {
        return this.entrypointService.update(entrypoint, GraviteeContext.getCurrentOrganization(), EntrypointReferenceType.ORGANIZATION);
    }

    @Path(value="{entrypoint}")
    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Delete a platform entrypoint", notes="User must have the MANAGEMENT_ENTRYPOINT[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Entrrypoint successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ENTRYPOINT, acls={RolePermissionAction.DELETE}), @Permission(value=RolePermission.ORGANIZATION_ENTRYPOINT, acls={RolePermissionAction.DELETE})})
    public void deleteEntrypoint(@PathParam(value="entrypoint") String entrypoint) {
        this.entrypointService.delete(entrypoint, GraviteeContext.getCurrentOrganization(), EntrypointReferenceType.ORGANIZATION);
    }
}

