/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"API Subscriptions"})
public class ApiSubscribersResource
extends AbstractResource {
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private ApplicationService applicationService;
    @Context
    private ResourceContext resourceContext;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List subscribers for the API", notes="User must have the MANAGE_SUBSCRIPTIONS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Paged result of API subscribers", response=ApplicationEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public Collection<ApplicationEntity> getApiSubscribers() {
        if (!this.hasPermission(RolePermission.API_SUBSCRIPTION, this.api, RolePermissionAction.READ) && !this.hasPermission(RolePermission.API_LOG, this.api, RolePermissionAction.READ)) {
            throw new ForbiddenAccessException();
        }
        SubscriptionQuery subscriptionQuery = new SubscriptionQuery();
        subscriptionQuery.setApi(this.api);
        Collection subscriptions = this.subscriptionService.search(subscriptionQuery);
        return subscriptions.stream().map(SubscriptionEntity::getApplication).distinct().map(application -> this.applicationService.findById(GraviteeContext.getCurrentEnvironment(), application)).sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName())).collect(Collectors.toList());
    }
}

