/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.AnalyticsAverageParam;
import io.gravitee.rest.api.management.rest.resource.param.healthcheck.HealthcheckFieldParam;
import io.gravitee.rest.api.management.rest.resource.param.healthcheck.HealthcheckTypeParam;
import io.gravitee.rest.api.management.rest.resource.param.healthcheck.LogsParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.analytics.Analytics;
import io.gravitee.rest.api.model.analytics.query.Aggregation;
import io.gravitee.rest.api.model.analytics.query.AggregationType;
import io.gravitee.rest.api.model.analytics.query.DateHistogramQuery;
import io.gravitee.rest.api.model.analytics.query.LogQuery;
import io.gravitee.rest.api.model.healthcheck.Log;
import io.gravitee.rest.api.model.healthcheck.SearchLogResponse;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.HealthCheckService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collections;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Api(tags={"API Health"})
public class ApiHealthResource
extends AbstractResource {
    @Inject
    private HealthCheckService healthCheckService;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Health-check statistics for API")
    @Permissions(value={@Permission(value=RolePermission.API_HEALTH, acls={RolePermissionAction.READ})})
    public Response getApiHealth(@QueryParam(value="type") @DefaultValue(value="availability") HealthcheckTypeParam healthcheckTypeParam, @QueryParam(value="field") @DefaultValue(value="endpoint") HealthcheckFieldParam healthcheckFieldParam) {
        switch ((HealthcheckTypeParam.HealthcheckType)((Object)healthcheckTypeParam.getValue())) {
            case RESPONSE_TIME: {
                return Response.ok((Object)this.healthCheckService.getResponseTime(this.api, ((HealthcheckFieldParam.HealthcheckField)((Object)healthcheckFieldParam.getValue())).name())).build();
            }
        }
        return Response.ok((Object)this.healthCheckService.getAvailability(this.api, ((HealthcheckFieldParam.HealthcheckField)((Object)healthcheckFieldParam.getValue())).name())).build();
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Health-check average statistics for API")
    @Permissions(value={@Permission(value=RolePermission.API_HEALTH, acls={RolePermissionAction.READ})})
    @Path(value="/average")
    public Response getApiHealthAverage(@BeanParam AnalyticsAverageParam analyticsAverageParam) {
        return Response.ok((Object)this.executeDateHisto(this.api, analyticsAverageParam)).build();
    }

    private Analytics executeDateHisto(String api, final AnalyticsAverageParam analyticsAverageParam) {
        DateHistogramQuery query = new DateHistogramQuery();
        query.setFrom(analyticsAverageParam.getFrom());
        query.setTo(analyticsAverageParam.getTo());
        query.setInterval(analyticsAverageParam.getInterval());
        query.setRootField("api");
        query.setRootIdentifier(api);
        query.setAggregations(Collections.singletonList(new Aggregation(){

            public AggregationType type() {
                switch (analyticsAverageParam.getType()) {
                    case AVAILABILITY: {
                        return AggregationType.FIELD;
                    }
                }
                return AggregationType.AVG;
            }

            public String field() {
                switch (analyticsAverageParam.getType()) {
                    case AVAILABILITY: {
                        return "available";
                    }
                }
                return "response-time";
            }
        }));
        return this.healthCheckService.query(query);
    }

    @GET
    @Path(value="logs")
    @Produces(value={"application/json"})
    @ApiOperation(value="Health-check logs")
    @ApiResponses(value={@ApiResponse(code=200, message="API logs"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_HEALTH, acls={RolePermissionAction.READ})})
    public SearchLogResponse getApiHealthCheckLogs(@BeanParam LogsParam param) {
        param.validate();
        LogQuery logQuery = new LogQuery();
        logQuery.setQuery(param.getQuery());
        logQuery.setPage(param.getPage());
        logQuery.setSize(param.getSize());
        logQuery.setFrom(param.getFrom());
        logQuery.setTo(param.getTo());
        return this.healthCheckService.findByApi(this.api, logQuery, param.isTransition());
    }

    @GET
    @Path(value="logs/{log}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Health-check log")
    @ApiResponses(value={@ApiResponse(code=200, message="Single health-check log"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_HEALTH, acls={RolePermissionAction.READ})})
    public Log getApiHealthCheckLog(@PathParam(value="log") String logId) {
        return this.healthCheckService.findLog(logId);
    }
}

