/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import io.gravitee.definition.jackson.datatype.GraviteeMapper;
import io.gravitee.rest.api.service.jackson.filter.ApiPermissionFilter;
import java.util.Collections;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;

@Provider
public class ObjectMapperResolver
implements ContextResolver<ObjectMapper> {
    private final ObjectMapper mapper = new GraviteeMapper();

    public ObjectMapperResolver() {
        this.mapper.enable(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS);
        this.registerFilterProvider();
    }

    public ObjectMapper getContext(Class<?> type) {
        return this.mapper;
    }

    private void registerFilterProvider() {
        ApiPermissionFilter apiMembershipTypeFilter = new ApiPermissionFilter();
        this.mapper.setFilterProvider((FilterProvider)new SimpleFilterProvider(Collections.singletonMap("apiMembershipTypeFilter", apiMembershipTypeFilter)));
    }
}

