/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.configuration.application.registration;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.configuration.application.registration.ClientRegistrationProviderEntity;
import io.gravitee.rest.api.model.configuration.application.registration.UpdateClientRegistrationProviderEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.configuration.application.ClientRegistrationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Api(tags={"Client Registration Providers"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ClientRegistrationProviderResource
extends AbstractResource {
    @Autowired
    private ClientRegistrationService clientRegistrationService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a client registration provider", notes="User must have the PORTAL_CLIENT_REGISTRATION_PROVIDER[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="A client registration provider"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CLIENT_REGISTRATION_PROVIDER, acls={RolePermissionAction.READ})})
    public ClientRegistrationProviderEntity getClientRegistrationProvider(@PathParam(value="clientRegistrationProvider") String clientRegistrationProvider) {
        return this.clientRegistrationService.findById(clientRegistrationProvider);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a client registration provider", notes="User must have the PORTAL_CLIENT_REGISTRATION_PROVIDER[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated client registration provider", response=ClientRegistrationProviderEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CLIENT_REGISTRATION_PROVIDER, acls={RolePermissionAction.UPDATE})})
    public ClientRegistrationProviderEntity updateClientRegistrationProvider(@PathParam(value="clientRegistrationProvider") String clientRegistrationProvider, @ApiParam(name="clientRegistrationProvider", required=true) @Valid @NotNull UpdateClientRegistrationProviderEntity updatedClientRegistrationProvider) {
        return this.clientRegistrationService.update(clientRegistrationProvider, updatedClientRegistrationProvider);
    }

    @DELETE
    @ApiOperation(value="Delete a client registration provider", notes="User must have the PORTAL_CLIENT_REGISTRATION_PROVIDER[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Client registration provider successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CLIENT_REGISTRATION_PROVIDER, acls={RolePermissionAction.DELETE})})
    public Response deleteClientRegistrationProvider(@PathParam(value="clientRegistrationProvider") String clientRegistrationProvider) {
        this.clientRegistrationService.delete(clientRegistrationProvider);
        return Response.noContent().build();
    }
}

