/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.PortalMediaResource;
import io.gravitee.rest.api.management.rest.resource.PortalPagesResource;
import io.gravitee.rest.api.management.rest.resource.portal.PortalApisResource;
import io.gravitee.rest.api.management.rest.resource.portal.SocialIdentityProvidersResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.settings.PortalConfigEntity;
import io.gravitee.rest.api.model.settings.PortalSettingsEntity;
import io.gravitee.rest.api.service.ConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Portal"})
public class PortalResource {
    @Inject
    private ConfigService configService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the portal configuration", notes="Every users can use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Portal configuration", response=PortalConfigEntity.class), @ApiResponse(code=500, message="Internal server error")})
    public PortalConfigEntity getPortalConfig() {
        return this.configService.getPortalConfig();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Save the portal configuration")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated portal configuration", response=PortalSettingsEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_SETTINGS, acls={RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE})})
    @Deprecated
    public Response savePortalConfig(@ApiParam(name="config", required=true) @NotNull PortalSettingsEntity portalSettingsEntity) {
        this.configService.save(portalSettingsEntity);
        return Response.ok().entity((Object)portalSettingsEntity).build();
    }

    @Path(value="pages")
    public PortalPagesResource getPortalPagesResource() {
        return (PortalPagesResource)this.resourceContext.getResource(PortalPagesResource.class);
    }

    @Path(value="apis")
    public PortalApisResource getPortalApisResource() {
        return (PortalApisResource)this.resourceContext.getResource(PortalApisResource.class);
    }

    @Path(value="media")
    public PortalMediaResource getPortalMediaResource() {
        return (PortalMediaResource)this.resourceContext.getResource(PortalMediaResource.class);
    }

    @Deprecated
    @Path(value="identities")
    public SocialIdentityProvidersResource getSocialIdentityProvidersResource() {
        return (SocialIdentityProvidersResource)this.resourceContext.getResource(SocialIdentityProvidersResource.class);
    }
}

