/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.exception.InvalidImageException;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.security.utils.ImageUtils;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.exceptions.UploadUnauthorized;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Api(tags={"Portal Media"})
public class PortalMediaResource
extends AbstractResource {
    @Inject
    private MediaService mediaService;

    @POST
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @ApiOperation(value="Create a media for the portal", notes="User must have the PORTAL_DOCUMENTATION[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Media successfully created"), @ApiResponse(code=500, message="Internal server error")})
    public Response uploadPortalMedia(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="file") FormDataBodyPart body) throws IOException {
        if (fileDetail.getSize() > this.mediaService.getMediaMaxSize()) {
            throw new UploadUnauthorized("Max size achieved " + fileDetail.getSize());
        }
        MediaEntity mediaEntity = new MediaEntity();
        mediaEntity.setSize(fileDetail.getSize());
        mediaEntity.setType(body.getMediaType().getType());
        mediaEntity.setSubType(body.getMediaType().getSubtype());
        mediaEntity.setData(IOUtils.toByteArray((InputStream)uploadedInputStream));
        mediaEntity.setFileName(fileDetail.getFileName());
        try {
            ImageUtils.verify((String)body.getMediaType().getType(), (String)body.getMediaType().getSubtype(), (byte[])mediaEntity.getData());
        }
        catch (InvalidImageException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid image format").build();
        }
        String mediaId = this.mediaService.savePortalMedia(mediaEntity);
        return Response.status((int)200).entity((Object)mediaId).build();
    }

    @GET
    @Path(value="/{hash}")
    @ApiOperation(value="Retrieve a media")
    @ApiResponses(value={@ApiResponse(code=200, message="A media"), @ApiResponse(code=500, message="Internal server error")})
    public Response getPortalMedia(@Context Request request, @PathParam(value="hash") String hash) {
        MediaEntity mediaEntity = this.mediaService.findByHash(hash);
        if (mediaEntity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        CacheControl cc = new CacheControl();
        cc.setNoTransform(true);
        cc.setMustRevalidate(false);
        cc.setNoCache(false);
        cc.setMaxAge(86400);
        EntityTag etag = new EntityTag(hash);
        Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
        if (builder != null) {
            return builder.cacheControl(cc).build();
        }
        return Response.ok((Object)mediaEntity.getData()).type(mediaEntity.getMimeType()).cacheControl(cc).tag(etag).build();
    }
}

