/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.model.Pageable;
import io.gravitee.rest.api.management.rest.model.PagedResult;
import io.gravitee.rest.api.management.rest.model.Subscription;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationSubscriptionResource;
import io.gravitee.rest.api.management.rest.resource.param.ListStringParam;
import io.gravitee.rest.api.management.rest.resource.param.ListSubscriptionStatusParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.NewSubscriptionEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Application Subscriptions"})
public class ApplicationSubscriptionsResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private PlanService planService;
    @Inject
    private ApiKeyService apiKeyService;
    @Inject
    private ApiService apiService;
    @Inject
    private UserService userService;
    @PathParam(value="application")
    @ApiParam(name="application", hidden=true)
    private String application;

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Subscribe to a plan", notes="User must have the MANAGE_SUBSCRIPTIONS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Subscription successfully created", response=Subscription.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.CREATE})})
    public Response createSubscriptionWithApplication(@ApiParam(name="plan", required=true) @NotNull @QueryParam(value="plan") String plan, NewSubscriptionEntity newSubscriptionEntity) {
        PlanEntity planEntity;
        if (newSubscriptionEntity == null) {
            newSubscriptionEntity = new NewSubscriptionEntity();
        }
        if ((planEntity = this.planService.findById(plan)).isCommentRequired() && (newSubscriptionEntity.getRequest() == null || newSubscriptionEntity.getRequest().isEmpty())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Plan requires a consumer comment when subscribing").build();
        }
        newSubscriptionEntity.setApplication(this.application);
        newSubscriptionEntity.setPlan(plan);
        Subscription subscription = this.convert(this.subscriptionService.create(newSubscriptionEntity));
        return Response.created((URI)this.getRequestUriBuilder().path(subscription.getId()).replaceQueryParam("plan", null).build(new Object[0])).entity((Object)subscription).build();
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List subscriptions for the application", notes="User must have the READ_SUBSCRIPTION permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Paged result of application's subscriptions", response=PagedResult.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public PagedResult<SubscriptionEntity> getApplicationSubscriptions(@BeanParam SubscriptionParam subscriptionParam, @Valid @BeanParam Pageable pageable, @ApiParam(allowableValues="keys", value="Expansion of data to return in subscriptions") @QueryParam(value="expand") List<String> expand) {
        SubscriptionQuery subscriptionQuery = subscriptionParam.toQuery();
        subscriptionQuery.setApplication(this.application);
        Page subscriptions = this.subscriptionService.search(subscriptionQuery, pageable.toPageable());
        if (expand != null && !expand.isEmpty()) {
            Iterator<String> iterator = expand.iterator();
            while (iterator.hasNext()) {
                String e;
                switch (e = iterator.next()) {
                    case "keys": {
                        subscriptions.getContent().forEach(subscriptionEntity -> {
                            List keys = this.apiKeyService.findBySubscription(subscriptionEntity.getId()).stream().filter(apiKeyEntity -> !apiKeyEntity.isExpired() && !apiKeyEntity.isRevoked()).map(ApiKeyEntity::getKey).collect(Collectors.toList());
                            subscriptionEntity.setKeys(keys);
                        });
                        break;
                    }
                }
            }
        }
        PagedResult<SubscriptionEntity> result = new PagedResult<SubscriptionEntity>(subscriptions, pageable.getSize());
        result.setMetadata(this.subscriptionService.getMetadata(subscriptions.getContent()).getMetadata());
        return result;
    }

    @Path(value="{subscription}")
    public ApplicationSubscriptionResource getApplicationSubscriptionResource() {
        return (ApplicationSubscriptionResource)this.resourceContext.getResource(ApplicationSubscriptionResource.class);
    }

    private Subscription convert(SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(subscriptionEntity.getCreatedAt());
        subscription.setUpdatedAt(subscriptionEntity.getUpdatedAt());
        subscription.setStartingAt(subscriptionEntity.getStartingAt());
        subscription.setEndingAt(subscriptionEntity.getEndingAt());
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt());
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setReason(subscriptionEntity.getReason());
        subscription.setRequest(subscriptionEntity.getRequest());
        subscription.setStatus(subscriptionEntity.getStatus());
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), this.userService.findById(subscriptionEntity.getSubscribedBy(), true).getDisplayName()));
        PlanEntity plan = this.planService.findById(subscriptionEntity.getPlan());
        subscription.setPlan(new Subscription.Plan(plan.getId(), plan.getName()));
        subscription.getPlan().setSecurity(plan.getSecurity());
        ApiEntity api = this.apiService.findById(subscriptionEntity.getApi());
        subscription.setApi(new Subscription.Api(api.getId(), api.getName(), api.getVersion(), new Subscription.User(api.getPrimaryOwner().getId(), api.getPrimaryOwner().getDisplayName())));
        subscription.setClosedAt(subscriptionEntity.getClosedAt());
        subscription.setPausedAt(subscriptionEntity.getPausedAt());
        return subscription;
    }

    private static class SubscriptionParam {
        @QueryParam(value="plan")
        @ApiParam(value="plan")
        private ListStringParam plans;
        @QueryParam(value="api")
        @ApiParam(value="api")
        private ListStringParam apis;
        @QueryParam(value="status")
        @DefaultValue(value="accepted,pending,paused")
        @ApiModelProperty(dataType="string", allowableValues="accepted, pending, rejected, closed", value="Subscription status")
        private ListSubscriptionStatusParam status;
        @QueryParam(value="api_key")
        private String apiKey;

        private SubscriptionParam() {
        }

        public ListStringParam getPlans() {
            return this.plans;
        }

        public void setPlans(ListStringParam plans) {
            this.plans = plans;
        }

        public ListStringParam getApis() {
            return this.apis;
        }

        public void setApis(ListStringParam apis) {
            this.apis = apis;
        }

        public ListSubscriptionStatusParam getStatus() {
            return this.status;
        }

        public void setStatus(ListSubscriptionStatusParam status) {
            this.status = status;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        private SubscriptionQuery toQuery() {
            SubscriptionQuery query = new SubscriptionQuery();
            if (this.apis != null && this.apis.getValue() != null) {
                query.setApis((Collection)this.apis.getValue());
            }
            if (this.plans != null && this.plans.getValue() != null) {
                query.setPlans((Collection)this.plans.getValue());
            }
            if (this.status != null) {
                query.setStatuses(this.status.getStatus());
            }
            if (this.apiKey != null) {
                query.setApiKey(this.apiKey);
            }
            return query;
        }
    }
}

