/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiKeyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Api(tags={"API Keys"})
public class ApplicationSubscriptionApiKeyResource
extends AbstractResource {
    @Inject
    private ApiKeyService apiKeyService;
    @PathParam(value="application")
    @ApiParam(name="application", hidden=true)
    private String application;
    @PathParam(value="subscription")
    @ApiParam(name="subscription", hidden=true)
    private String subscription;
    @PathParam(value="apikey")
    @ApiParam(name="apikey", hidden=true)
    private String apikey;

    @DELETE
    @Produces(value={"application/json"})
    @ApiOperation(value="Revoke an API key", notes="User must have the MANAGE_API_KEYS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="API key successfully revoked"), @ApiResponse(code=400, message="API Key does not correspond to the subscription"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response revokeApiKeyForApplicationSubscription() {
        ApiKeyEntity apiKeyEntity = this.apiKeyService.findById(this.apikey);
        if (apiKeyEntity.getSubscription() != null && !this.subscription.equals(apiKeyEntity.getSubscription())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'key' parameter does not correspond to the subscription").build();
        }
        this.apiKeyService.revoke(apiKeyEntity, true);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

