/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.LogsParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.analytics.query.LogQuery;
import io.gravitee.rest.api.model.log.ApplicationRequest;
import io.gravitee.rest.api.model.log.SearchLogResponse;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.LogsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Api(tags={"Application Logs"})
public class ApplicationLogsResource
extends AbstractResource {
    @Inject
    private LogsService logsService;
    @PathParam(value="application")
    @ApiParam(name="application", hidden=true)
    private String application;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get application logs")
    @ApiResponses(value={@ApiResponse(code=200, message="Application logs"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_LOG, acls={RolePermissionAction.READ})})
    public SearchLogResponse getApplicationLogs(@BeanParam LogsParam param) {
        param.validate();
        LogQuery logQuery = new LogQuery();
        logQuery.setQuery(param.getQuery());
        logQuery.setPage(param.getPage());
        logQuery.setSize(param.getSize());
        logQuery.setFrom(param.getFrom());
        logQuery.setTo(param.getTo());
        logQuery.setField(param.getField());
        logQuery.setOrder(param.isOrder());
        return this.logsService.findByApplication(this.application, logQuery);
    }

    @GET
    @Path(value="/{log}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a specific log")
    @ApiResponses(value={@ApiResponse(code=200, message="Single log"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_LOG, acls={RolePermissionAction.READ})})
    public ApplicationRequest getApplicationLog(@PathParam(value="log") String logId, @QueryParam(value="timestamp") Long timestamp) {
        return this.logsService.findApplicationLog(logId, timestamp);
    }

    @GET
    @Path(value="export")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Export application logs as CSV")
    @ApiResponses(value={@ApiResponse(code=200, message="Application logs as CSV"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_LOG, acls={RolePermissionAction.READ})})
    public Response exportApplicationLogsAsCSV(@BeanParam LogsParam param) {
        SearchLogResponse searchLogResponse = this.getApplicationLogs(param);
        return Response.ok((Object)this.logsService.exportAsCsv(searchLogResponse)).header("Content-Disposition", (Object)String.format("attachment;filename=logs-%s-%s.csv", this.application, System.currentTimeMillis())).build();
    }
}

