/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.Subscription;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscriptionApiKeysResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.ProcessSubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.TransferSubscriptionEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.validator.CustomApiKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Api(tags={"API Subscriptions"})
public class ApiSubscriptionResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private ApiKeyService apiKeyService;
    @Inject
    private PlanService planService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private UserService userService;
    @Inject
    private ParameterService parameterService;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a subscription", notes="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Get a subscription", response=Subscription.class), @ApiResponse(code=404, message="Subscription does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public Subscription getApiSubscription(@PathParam(value="subscription") String subscription) {
        return this.convert(this.subscriptionService.findById(subscription));
    }

    @POST
    @Path(value="/_process")
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a subscription", notes="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Update a subscription", response=Subscription.class), @ApiResponse(code=400, message="Bad subscription format"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response processApiSubscription(@PathParam(value="subscription") String subscription, @ApiParam(name="subscription", required=true) @Valid @NotNull ProcessSubscriptionEntity processSubscriptionEntity) {
        if (processSubscriptionEntity.getId() != null && !subscription.equals(processSubscriptionEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'subscription' parameter does not correspond to the subscription to process").build();
        }
        processSubscriptionEntity.setId(subscription);
        SubscriptionEntity subscriptionEntity = this.subscriptionService.process(processSubscriptionEntity, this.getAuthenticatedUser());
        return Response.ok((Object)this.convert(subscriptionEntity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a subscription", notes="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Update a subscription", response=Subscription.class), @ApiResponse(code=400, message="Bad subscription format"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response updateApiSubscription(@PathParam(value="subscription") String subscription, @ApiParam(name="subscription", required=true) @Valid @NotNull UpdateSubscriptionEntity updateSubscriptionEntity) {
        if (updateSubscriptionEntity.getId() != null && !subscription.equals(updateSubscriptionEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'subscription' parameter does not correspond to the subscription to update").build();
        }
        updateSubscriptionEntity.setId(subscription);
        SubscriptionEntity subscriptionEntity = this.subscriptionService.update(updateSubscriptionEntity);
        return Response.ok((Object)this.convert(subscriptionEntity)).build();
    }

    @POST
    @Path(value="/status")
    @Produces(value={"application/json"})
    @ApiOperation(value="Change the status of a subscription", notes="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Subscription status successfully updated", response=Subscription.class), @ApiResponse(code=400, message="Status changes not authorized"), @ApiResponse(code=404, message="API subscription does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response changeApiSubscriptionStatus(@PathParam(value="subscription") String subscription, @ApiParam(required=true, allowableValues="CLOSED, PAUSED, RESUMED") @QueryParam(value="status") SubscriptionStatus subscriptionStatus) {
        if (SubscriptionStatus.CLOSED.equals((Object)subscriptionStatus)) {
            SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.close(subscription);
            return Response.ok((Object)this.convert(updatedSubscriptionEntity)).build();
        }
        if (SubscriptionStatus.PAUSED.equals((Object)subscriptionStatus)) {
            SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.pause(subscription);
            return Response.ok((Object)this.convert(updatedSubscriptionEntity)).build();
        }
        if (SubscriptionStatus.RESUMED.equals((Object)subscriptionStatus)) {
            SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.resume(subscription);
            return Response.ok((Object)this.convert(updatedSubscriptionEntity)).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Deprecated(forRemoval=true, since="v3.12")
    @GET
    @Path(value="/keys")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated, use GET /apis/{apiId}/subscriptions/{subscriptionId}/apikeys instead", notes="User must have the MANAGE_API_KEYS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of API Keys for a subscription", response=ApiKeyEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public List<ApiKeyEntity> getApiKeysForSubscription(@PathParam(value="subscription") String subscription) {
        return this.apiKeyService.findBySubscription(subscription);
    }

    @Deprecated(forRemoval=true, since="v3.12")
    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated, use POST /apis/{apiId}/subscriptions/{subscriptionId}/apikeys/_renew instead", notes="User must have the MANAGE_API_KEYS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="A new API Key", response=ApiKeyEntity.class), @ApiResponse(code=400, message="Bad custom API Key format or custom API Key definition disabled"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response renewApiKey(@PathParam(value="subscription") String subscription, @ApiParam(name="customApiKey") @CustomApiKey @QueryParam(value="customApiKey") String customApiKey) {
        if (StringUtils.isNotEmpty((CharSequence)customApiKey) && !this.parameterService.findAsBoolean(Key.PLAN_SECURITY_APIKEY_CUSTOM_ALLOWED, ParameterReferenceType.ENVIRONMENT)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"You are not allowed to provide a custom API Key").build();
        }
        ApiKeyEntity apiKeyEntity = this.apiKeyService.renew(subscription, customApiKey);
        return Response.created((URI)this.getLocationHeader("keys", apiKeyEntity.getKey())).entity((Object)apiKeyEntity).build();
    }

    @Deprecated(forRemoval=true, since="v3.12")
    @DELETE
    @Path(value="/keys/{key}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated, use DELETE /apis/{apiId}/subscriptions/{subscriptionId}/apikeys/{apiKeyId} instead", notes="User must have the API_SUBSCRIPTION permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="API key successfully revoked"), @ApiResponse(code=400, message="API Key does not correspond to the subscription"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response revokeSubscriptionApiKey(@PathParam(value="subscription") String subscription, @PathParam(value="key") String apiKey) {
        ApiKeyEntity apiKeyEntity = this.apiKeyService.findByKeyAndApi(apiKey, this.api);
        if (apiKeyEntity.getSubscription() != null && !subscription.equals(apiKeyEntity.getSubscription())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'key' parameter does not correspond to the subscription").build();
        }
        this.apiKeyService.revoke(apiKeyEntity, true);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Deprecated(forRemoval=true, since="v3.12")
    @POST
    @Path(value="/keys/{key}/_reactivate")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated, use POST /apis/{apiId}/subscriptions/{subscriptionId}/apikeys/{apiKeyId}/_reactivate instead", notes="User must have the API_SUBSCRIPTION permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="API key successfully reactivated"), @ApiResponse(code=400, message="API Key does not correspond to the subscription"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response reactivateApiKey(@PathParam(value="subscription") String subscription, @PathParam(value="key") String apiKey) {
        ApiKeyEntity apiKeyEntity = this.apiKeyService.findByKeyAndApi(apiKey, this.api);
        if (apiKeyEntity.getSubscription() != null && !subscription.equals(apiKeyEntity.getSubscription())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'key' parameter does not correspond to the subscription").build();
        }
        ApiKeyEntity reactivated = this.apiKeyService.reactivate(apiKeyEntity);
        return Response.ok().entity((Object)reactivated).build();
    }

    @POST
    @Path(value="/_transfer")
    @Produces(value={"application/json"})
    @ApiOperation(value="Transfer a subscription", notes="User must have the API_SUBSCRIPTION update permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Update a subscription", response=Subscription.class), @ApiResponse(code=400, message="Bad subscription format"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response transferApiSubscription(@PathParam(value="subscription") String subscription, @ApiParam(name="subscription", required=true) @Valid @NotNull TransferSubscriptionEntity transferSubscriptionEntity) {
        if (transferSubscriptionEntity.getId() != null && !subscription.equals(transferSubscriptionEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'subscription' parameter does not correspond to the subscription to process").build();
        }
        transferSubscriptionEntity.setId(subscription);
        SubscriptionEntity subscriptionEntity = this.subscriptionService.transfer(transferSubscriptionEntity, this.getAuthenticatedUser());
        return Response.ok((Object)this.convert(subscriptionEntity)).build();
    }

    private Subscription convert(SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(subscriptionEntity.getCreatedAt());
        subscription.setUpdatedAt(subscriptionEntity.getUpdatedAt());
        subscription.setStartingAt(subscriptionEntity.getStartingAt());
        subscription.setEndingAt(subscriptionEntity.getEndingAt());
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt());
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setRequest(subscriptionEntity.getRequest());
        subscription.setReason(subscriptionEntity.getReason());
        subscription.setRequest(subscriptionEntity.getRequest());
        subscription.setStatus(subscriptionEntity.getStatus());
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), this.userService.findById(subscriptionEntity.getSubscribedBy(), true).getDisplayName()));
        subscription.setClientId(subscriptionEntity.getClientId());
        PlanEntity plan = this.planService.findById(subscriptionEntity.getPlan());
        subscription.setPlan(new Subscription.Plan(plan.getId(), plan.getName()));
        subscription.getPlan().setSecurity(plan.getSecurity());
        ApplicationEntity application = this.applicationService.findById(subscriptionEntity.getApplication());
        subscription.setApplication(new Subscription.Application(application.getId(), application.getName(), application.getType(), application.getDescription(), new Subscription.User(application.getPrimaryOwner().getId(), application.getPrimaryOwner().getDisplayName())));
        subscription.setClosedAt(subscriptionEntity.getClosedAt());
        subscription.setPausedAt(subscriptionEntity.getPausedAt());
        return subscription;
    }

    @Path(value="apikeys")
    public ApiSubscriptionApiKeysResource getApiSubscriptionApiKeysResourceResource() {
        return (ApiSubscriptionApiKeysResource)this.resourceContext.getResource(ApiSubscriptionApiKeysResource.class);
    }
}

