/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscriptionApiKeyResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.validator.CustomApiKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Api(tags={"API Keys"})
public class ApiSubscriptionApiKeysResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ApiKeyService apiKeyService;
    @Inject
    private ParameterService parameterService;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;
    @PathParam(value="subscription")
    @ApiParam(name="subscription", hidden=true)
    private String subscription;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List all API Keys for a subscription", notes="User must have the MANAGE_API_KEYS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of API Keys for a subscription", response=ApiKeyEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public List<ApiKeyEntity> getApiKeysForApiSubscription() {
        return this.apiKeyService.findBySubscription(this.subscription);
    }

    @POST
    @Path(value="/_renew")
    @Produces(value={"application/json"})
    @ApiOperation(value="Renew an API key", notes="User must have the MANAGE_API_KEYS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="A new API Key", response=ApiKeyEntity.class), @ApiResponse(code=400, message="Bad custom API Key format or custom API Key definition disabled"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response renewSubscriptionApiKeysForApiSubscription(@ApiParam(name="customApiKey") @CustomApiKey @QueryParam(value="customApiKey") String customApiKey) {
        if (StringUtils.isNotEmpty((CharSequence)customApiKey) && !this.parameterService.findAsBoolean(Key.PLAN_SECURITY_APIKEY_CUSTOM_ALLOWED, ParameterReferenceType.ENVIRONMENT)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"You are not allowed to provide a custom API Key").build();
        }
        ApiKeyEntity apiKeyEntity = this.apiKeyService.renew(this.subscription, customApiKey);
        URI location = URI.create(this.uriInfo.getPath().replace("_renew", apiKeyEntity.getId()));
        return Response.created((URI)location).entity((Object)apiKeyEntity).build();
    }

    @Path(value="{apikey}")
    public ApiSubscriptionApiKeyResource getApiSubscriptionApiKeyResource() {
        return (ApiSubscriptionApiKeyResource)this.resourceContext.getResource(ApiSubscriptionApiKeyResource.class);
    }
}

