/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiPageMediaResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.management.rest.utils.HttpHeadersUtil;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.UpdatePageEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AccessControlService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.PageMarkdownTemplateActionException;
import io.gravitee.rest.api.service.exceptions.PageSystemFolderActionException;
import io.gravitee.rest.api.service.exceptions.SwaggerDescriptorException;
import io.gravitee.rest.api.service.exceptions.UnauthorizedAccessException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collections;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"API Pages"})
public class ApiPageResource
extends AbstractResource {
    @Inject
    private PageService pageService;
    @Inject
    private AccessControlService accessControlService;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;
    @PathParam(value="page")
    @ApiParam(name="page", required=true)
    private String page;
    @Context
    private ResourceContext resourceContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a page", notes="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Page"), @ApiResponse(code=500, message="Internal server error")})
    public PageEntity getApiPage(@HeaderParam(value="Accept-Language") String acceptLang, @QueryParam(value="portal") boolean portal, @QueryParam(value="translated") boolean translated) {
        String acceptedLocale = HttpHeadersUtil.getFirstAcceptedLocaleName(acceptLang);
        ApiEntity apiEntity = this.apiService.findById(this.api);
        if (Visibility.PUBLIC.equals((Object)apiEntity.getVisibility()) || this.hasPermission(RolePermission.API_DOCUMENTATION, this.api, RolePermissionAction.READ)) {
            PageEntity pageEntity = this.pageService.findById(this.page, translated ? acceptedLocale : null);
            pageEntity.setGeneralConditions(this.pageService.isPageUsedAsGeneralConditions(pageEntity, this.api));
            if (portal) {
                this.pageService.transformSwagger(pageEntity, this.api);
                if (!this.isAuthenticated() && pageEntity.getMetadata() != null) {
                    pageEntity.getMetadata().clear();
                }
            }
            if (this.isDisplayable(apiEntity, pageEntity)) {
                if (pageEntity.getContentType() != null) {
                    String content = pageEntity.getContent();
                    try {
                        this.pageService.validateSafeContent(pageEntity, this.api);
                    }
                    catch (SwaggerDescriptorException contentException) {
                        pageEntity.setMessages(Collections.singletonList(contentException.getMessage()));
                    }
                    finally {
                        pageEntity.setContent(content);
                    }
                }
                return pageEntity;
            }
            throw new UnauthorizedAccessException();
        }
        throw new ForbiddenAccessException();
    }

    @GET
    @Path(value="/content")
    @ApiOperation(value="Get the page's content", notes="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Page's content"), @ApiResponse(code=500, message="Internal server error")})
    public Response getApiPageContent() {
        PageEntity pageEntity = this.getApiPage(null, true, false);
        return Response.ok((Object)pageEntity.getContent(), (String)pageEntity.getContentType()).build();
    }

    @PUT
    @Path(value="/content")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Put the page's content", notes="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Page content successfully updated"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public String updatePageContent(@ApiParam(name="content", required=true) @Valid @NotNull String content) {
        this.pageService.findById(this.page);
        UpdatePageEntity updatePageEntity = new UpdatePageEntity();
        updatePageEntity.setContent(content);
        PageEntity update = this.pageService.update(this.page, updatePageEntity, true);
        return update.getContent();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a page", notes="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Page successfully updated", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public PageEntity updateApiPage(@ApiParam(name="page", required=true) @Valid @NotNull UpdatePageEntity updatePageEntity) {
        PageEntity existingPage = this.pageService.findById(this.page);
        if (existingPage.getType().equals(PageType.SYSTEM_FOLDER.name())) {
            throw new PageSystemFolderActionException("Update");
        }
        if (existingPage.getType().equals(PageType.MARKDOWN_TEMPLATE.name())) {
            throw new PageMarkdownTemplateActionException("Update");
        }
        updatePageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.update(this.page, updatePageEntity);
    }

    @POST
    @Path(value="/_fetch")
    @Produces(value={"application/json"})
    @ApiOperation(value="Refresh page by calling the associated fetcher", notes="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Page successfully refreshed", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public PageEntity fetchApiPage() {
        this.pageService.findById(this.page);
        String contributor = this.getAuthenticatedUser();
        return this.pageService.fetch(this.page, contributor);
    }

    @PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a page", notes="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Page successfully updated", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public PageEntity partialUpdateApiPage(@ApiParam(name="page") UpdatePageEntity updatePageEntity) {
        PageEntity existingPage = this.pageService.findById(this.page);
        if (existingPage.getType().equals(PageType.SYSTEM_FOLDER.name())) {
            throw new PageSystemFolderActionException("Update");
        }
        if (existingPage.getType().equals(PageType.MARKDOWN_TEMPLATE.name())) {
            throw new PageMarkdownTemplateActionException("Update");
        }
        updatePageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.update(this.page, updatePageEntity, true);
    }

    @DELETE
    @ApiOperation(value="Delete a page", notes="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Page successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.DELETE})})
    public void deleteApiPage() {
        PageEntity existingPage = this.pageService.findById(this.page);
        if (existingPage.getType().equals(PageType.SYSTEM_FOLDER.name())) {
            throw new PageSystemFolderActionException("Delete");
        }
        if (existingPage.getType().equals(PageType.MARKDOWN_TEMPLATE.name())) {
            throw new PageMarkdownTemplateActionException("Delete");
        }
        this.pageService.delete(this.page);
    }

    private boolean isDisplayable(ApiEntity api, PageEntity pageEntity) {
        return this.isAuthenticated() && this.isAdmin() || this.accessControlService.canAccessPageFromConsole(api, pageEntity);
    }

    @Path(value="media")
    public ApiPageMediaResource getApiPageMediaResource() {
        return (ApiPageMediaResource)this.resourceContext.getResource(ApiPageMediaResource.class);
    }
}

