/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.api.header.ApiHeaderEntity;
import io.gravitee.rest.api.model.api.header.UpdateApiHeaderEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiHeaderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Api(tags={"Configuration"})
public class ApiHeaderResource
extends AbstractResource {
    @Inject
    private ApiHeaderService apiHeaderService;

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an API header", notes="User must have the PORTAL_API_HEADER[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API header successfully updated", response=ApiHeaderEntity.class), @ApiResponse(code=404, message="API header not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API_HEADER, acls={RolePermissionAction.UPDATE})})
    public ApiHeaderEntity updateApiHeader(@PathParam(value="id") String id, @Valid @NotNull UpdateApiHeaderEntity updateApiHeaderEntity) {
        updateApiHeaderEntity.setId(id);
        return this.apiHeaderService.update(updateApiHeaderEntity);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Delete an API header", notes="User must have the PORTAL_API_HEADER[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API header successfully deleted"), @ApiResponse(code=404, message="API header not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API_HEADER, acls={RolePermissionAction.DELETE})})
    public void deleteApiHeader(@PathParam(value="id") String id) {
        this.apiHeaderService.delete(id);
    }
}

