/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.NewExternalUserEntity;
import io.gravitee.rest.api.model.RegisterUserEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"User Registration"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UsersRegistrationResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private UserService userService;

    @POST
    @ApiOperation(value="Register a user", notes="User registration must be enabled")
    @ApiResponses(value={@ApiResponse(code=200, message="User successfully registered", response=UserEntity.class), @ApiResponse(code=500, message="Internal server error")})
    public Response registerUser(@Valid NewExternalUserEntity newExternalUserEntity) {
        UserEntity newUser = this.userService.register(newExternalUserEntity);
        if (newUser != null) {
            return Response.ok().entity((Object)newUser).build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="/finalize")
    @ApiOperation(value="Finalize user registration", notes="User registration must be enabled")
    @ApiResponses(value={@ApiResponse(code=200, message="User successfully created", response=UserEntity.class), @ApiResponse(code=500, message="Internal server error")})
    public Response finalizeUserRegistration(@Valid RegisterUserEntity registerUserEntity) {
        UserEntity newUser = this.userService.finalizeRegistration(registerUserEntity);
        if (newUser != null) {
            return Response.ok().entity((Object)newUser).build();
        }
        return Response.serverError().build();
    }
}

