/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.configuration.dictionary;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.LifecycleActionParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryEntity;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryType;
import io.gravitee.rest.api.model.configuration.dictionary.UpdateDictionaryEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.configuration.dictionary.DictionaryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Api(tags={"Configuration", "Dictionaries"})
public class DictionaryResource
extends AbstractResource {
    @Autowired
    private DictionaryService dictionaryService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a dictionary", notes="User must have the DICTIONARY[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="A dictionary"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.READ})})
    public DictionaryEntity getDictionary(@PathParam(value="dictionary") String dictionary) {
        DictionaryEntity dictionaryEntity = this.dictionaryService.findById(dictionary);
        boolean notReadOnly = this.hasPermission(RolePermission.ENVIRONMENT_DICTIONARY, RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE);
        if (!notReadOnly) {
            dictionaryEntity.setProvider(null);
            dictionaryEntity.setTrigger(null);
        }
        return dictionaryEntity;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a dictionary", notes="User must have the DICTIONARY[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated dictionary", response=DictionaryEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.UPDATE})})
    public DictionaryEntity updateDictionary(@PathParam(value="dictionary") String dictionary, @ApiParam(name="dictionary", required=true) @Valid @NotNull UpdateDictionaryEntity updatedDictionary) {
        return this.dictionaryService.update(dictionary, updatedDictionary);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="_deploy")
    @ApiOperation(value="Deploy dictionary to API gateway", notes="User must have the DICTIONARY[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Dictionary successfully deployed", response=DictionaryEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.UPDATE})})
    public Response deployDictionary(@PathParam(value="dictionary") String dictionary) {
        DictionaryEntity dictionaryEntity = this.dictionaryService.findById(dictionary);
        if (dictionaryEntity.getType() == DictionaryType.MANUAL) {
            dictionaryEntity = this.dictionaryService.deploy(dictionary);
            return Response.ok((Object)dictionaryEntity).tag(Long.toString(dictionaryEntity.getUpdatedAt().getTime())).lastModified(dictionaryEntity.getUpdatedAt()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"An automatic dictionary can not be deployed manually").build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="_undeploy")
    @ApiOperation(value="Undeploy dictionary to API gateway", notes="User must have the DICTIONARY[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Dictionary successfully undeployed", response=DictionaryEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.UPDATE})})
    public Response undeployDictionary(@PathParam(value="dictionary") String dictionary) {
        DictionaryEntity dictionaryEntity = this.dictionaryService.findById(dictionary);
        if (dictionaryEntity.getType() == DictionaryType.MANUAL) {
            dictionaryEntity = this.dictionaryService.undeploy(dictionary);
            return Response.ok((Object)dictionaryEntity).tag(Long.toString(dictionaryEntity.getUpdatedAt().getTime())).lastModified(dictionaryEntity.getUpdatedAt()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"An automatic dictionary can not be undeployed manually").build();
    }

    @DELETE
    @ApiOperation(value="Delete a dictionary", notes="User must have the DICTIONARY[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Dictionary successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.DELETE})})
    public Response deleteDictionary(@PathParam(value="dictionary") String dictionary) {
        this.dictionaryService.delete(dictionary);
        return Response.noContent().build();
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Manage the dictionary's lifecycle", notes="User must have the DICTIONARY[LIFECYCLE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Dictionary state updated"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.UPDATE})})
    public Response doLifecycleAction(@Context HttpHeaders headers, @ApiParam(required=true, allowableValues="START, STOP") @QueryParam(value="action") LifecycleActionParam action, @PathParam(value="dictionary") String dictionary) {
        DictionaryEntity dictionaryEntity = this.dictionaryService.findById(dictionary);
        if (dictionaryEntity.getType() == DictionaryType.DYNAMIC) {
            switch (action.getAction()) {
                case START: {
                    this.checkLifecycle(dictionaryEntity, action.getAction());
                    dictionaryEntity = this.dictionaryService.start(dictionary);
                    break;
                }
                case STOP: {
                    this.checkLifecycle(dictionaryEntity, action.getAction());
                    dictionaryEntity = this.dictionaryService.stop(dictionary);
                    break;
                }
                default: {
                    dictionaryEntity = null;
                }
            }
            return Response.ok((Object)dictionaryEntity).tag(Long.toString(dictionaryEntity.getUpdatedAt().getTime())).lastModified(dictionaryEntity.getUpdatedAt()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"A manual dictionary can not be started/stopped manually").build();
    }

    private void checkLifecycle(DictionaryEntity dictionary, LifecycleActionParam.LifecycleAction action) {
        switch (dictionary.getState()) {
            case STARTED: {
                if (!LifecycleActionParam.LifecycleAction.START.equals((Object)action)) break;
                throw new BadRequestException("Dictionary is already started");
            }
            case STOPPED: {
                if (!LifecycleActionParam.LifecycleAction.STOP.equals((Object)action)) break;
                throw new BadRequestException("Dictionary is already stopped");
            }
        }
    }
}

