/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.NewTokenEntity;
import io.gravitee.rest.api.model.TokenEntity;
import io.gravitee.rest.api.service.TokenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Api(tags={"User Tokens"})
public class TokensResource
extends AbstractResource {
    @Inject
    private TokenService tokenService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List user's personal tokens")
    @ApiResponses(value={@ApiResponse(code=200, message="User's personal tokens"), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    public List<TokenEntity> getTokens() {
        return this.tokenService.findByUser(this.getAuthenticatedUser()).stream().sorted(Comparator.comparing(TokenEntity::getCreatedAt)).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a personal token")
    @ApiResponses(value={@ApiResponse(code=201, message="A new personal token", response=TokenEntity.class), @ApiResponse(code=500, message="Internal server error")})
    public TokenEntity createTokens(@Valid @NotNull NewTokenEntity token) {
        return this.tokenService.create(token);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Revoke all user's personal tokens")
    @ApiResponses(value={@ApiResponse(code=204, message="User's personal tokens revoked"), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    public void revokeAllTokens() {
        this.tokenService.revokeByUser(this.getAuthenticatedUser());
    }

    @Path(value="{token}")
    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Revoke a single user's personal tokens")
    @ApiResponses(value={@ApiResponse(code=204, message="User's personal token revoked"), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    public void revokeToken(@PathParam(value="token") String tokenId) {
        this.tokenService.revoke(tokenId);
    }
}

