/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.platform.plugin.PluginEntity;
import io.gravitee.rest.api.service.ResourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Plugins"})
public class ResourceResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ResourceService resourceService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a resource", notes="User must have the MANAGEMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Resource plugin", response=PluginEntity.class), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public PluginEntity getResource(@PathParam(value="resource") String resource) {
        return this.resourceService.findById(resource);
    }

    @GET
    @Path(value="schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a resource's schema", notes="User must have the MANAGEMENT_API[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getResourceSchema(@PathParam(value="resource") String resource) {
        this.resourceService.findById(resource);
        return this.resourceService.getSchema(resource);
    }

    @GET
    @Path(value="documentation")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get a resource's documentation", notes="User must have the MANAGEMENT_API[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getResourceDoc(@PathParam(value="resource") String resource) {
        this.resourceService.findById(resource);
        return this.resourceService.getDocumentation(resource);
    }
}

