/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.model.Pageable;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.TicketsParam;
import io.gravitee.rest.api.model.NewTicketEntity;
import io.gravitee.rest.api.model.TicketEntity;
import io.gravitee.rest.api.model.api.TicketQuery;
import io.gravitee.rest.api.model.common.SortableImpl;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.TicketService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Api(tags={"Platform Tickets"})
public class PlatformTicketsResource
extends AbstractResource {
    @Inject
    private TicketService ticketService;

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Create a platform ticket")
    @ApiResponses(value={@ApiResponse(code=201, message="Ticket succesfully created"), @ApiResponse(code=500, message="Internal server error")})
    public Response createPlatformTicket(@Valid @NotNull NewTicketEntity ticketEntity) {
        this.ticketService.create(this.getAuthenticatedUser(), ticketEntity, GraviteeContext.getCurrentOrganization(), ParameterReferenceType.ORGANIZATION);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Search for platform tickets written by current user")
    @ApiResponses(value={@ApiResponse(code=200, message="List platform tickets written by current user", response=Page.class), @ApiResponse(code=500, message="Internal server error")})
    public Page<TicketEntity> getTickets(@Valid @BeanParam Pageable pageable, @Valid @BeanParam TicketsParam ticketsParam) {
        TicketQuery query = new TicketQuery();
        query.setApi(ticketsParam.getApi());
        query.setApplication(ticketsParam.getApplication());
        query.setApi(ticketsParam.getApi());
        query.setFromUser(this.getAuthenticatedUser());
        SortableImpl sortable = null;
        if (ticketsParam.getOrder() != null) {
            sortable = new SortableImpl(ticketsParam.getOrder().getField(), ticketsParam.getOrder().isOrder());
        }
        return this.ticketService.search(query, sortable, pageable.toPageable());
    }

    @GET
    @Path(value="/{ticket}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a specific ticket")
    @ApiResponses(value={@ApiResponse(code=200, message="Get a platform ticket", response=TicketEntity.class), @ApiResponse(code=404, message="Ticket not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTicket(@PathParam(value="ticket") String ticketId) {
        TicketEntity ticketEntity = this.ticketService.findById(ticketId);
        return Response.ok((Object)ticketEntity).build();
    }
}

