/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApplicationMetadataEntity;
import io.gravitee.rest.api.model.NewApplicationMetadataEntity;
import io.gravitee.rest.api.model.UpdateApplicationMetadataEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApplicationMetadataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Api(tags={"Application Metadata"})
public class ApplicationMetadataResource
extends AbstractResource {
    @Inject
    private ApplicationMetadataService metadataService;
    @PathParam(value="application")
    @ApiParam(name="application", hidden=true)
    private String application;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List metadata for an application", notes="User must have the APPLICATION_METADATA[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of metadata for an application", response=ApplicationMetadataEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_METADATA, acls={RolePermissionAction.READ})})
    public List<ApplicationMetadataEntity> getApplicationMetadatas() {
        return this.metadataService.findAllByApplication(this.application);
    }

    @GET
    @Path(value="{metadata}")
    @Produces(value={"application/json"})
    @ApiOperation(value="A metadata for an application and metadata id", notes="User must have the APPLICATION_METADATA[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="A metadata", response=ApplicationMetadataEntity.class), @ApiResponse(code=404, message="Metadata not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_METADATA, acls={RolePermissionAction.READ})})
    public ApplicationMetadataEntity getApplicationMetadata(@PathParam(value="metadata") String metadata) {
        return this.metadataService.findByIdAndApplication(metadata, this.application);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create an application metadata", notes="User must have the APPLICATION_METADATA[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Application metadata successfully created", response=ApplicationMetadataEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_METADATA, acls={RolePermissionAction.CREATE})})
    public Response createApplicationMetadata(@Valid @NotNull NewApplicationMetadataEntity metadata) {
        metadata.setApplicationId(this.application);
        ApplicationMetadataEntity applicationMetadataEntity = this.metadataService.create(metadata);
        return Response.created((URI)this.getLocationHeader(applicationMetadataEntity.getKey())).entity((Object)applicationMetadataEntity).build();
    }

    @PUT
    @Path(value="{metadata}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an application metadata", notes="User must have the APPLICATION_METADATA[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated application metadata", response=ApplicationMetadataEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_METADATA, acls={RolePermissionAction.UPDATE})})
    public Response updateApplicationMetadata(@PathParam(value="metadata") String metadataPathParam, @Valid @NotNull UpdateApplicationMetadataEntity metadata) {
        metadata.setApplicationId(this.application);
        return Response.ok((Object)this.metadataService.update(metadata)).build();
    }

    @DELETE
    @Path(value="{metadata}")
    @ApiOperation(value="Delete a metadata", notes="User must have the APPLICATION_METADATA[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Metadata successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_METADATA, acls={RolePermissionAction.DELETE})})
    public Response deleteApplicationMetadata(@PathParam(value="metadata") String metadata) {
        this.metadataService.delete(metadata, this.application);
        return Response.noContent().build();
    }
}

