/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.validator.CustomApiKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Deprecated(forRemoval=true, since="v3.12")
@Api(tags={"API Keys"})
public class ApiKeysResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ApiKeyService apiKeyService;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;

    @Deprecated(forRemoval=true, since="v3.12")
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated, use DELETE /apis/{apiId}/subscriptions/{subscriptionId}/apikeys/{keyId} endpoint instead", notes="User must have the API_SUBSCRIPTION:DELETE permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response revokeApiKey(@PathParam(value="key") @ApiParam(value="The API key") String apiKey) {
        this.apiKeyService.revoke(apiKey, this.api, true);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Deprecated(forRemoval=true, since="v3.12")
    @PUT
    @Path(value="{key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated, use PUT /apis/{apiId}/subscriptions/{subscriptionId}/apikeys/{keyId} endpoint instead", notes="User must have the API_SUBSCRIPTION:UPDATE permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API Key successfully updated", response=ApiKeyEntity.class), @ApiResponse(code=400, message="Bad plan format"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response updateApiKey(@PathParam(value="key") @ApiParam(value="The API key") String apiKey, @Valid @NotNull ApiKeyEntity apiKeyEntity) {
        if (apiKeyEntity.getKey() != null && !apiKey.equals(apiKeyEntity.getKey())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'apiKey' parameter does not correspond to the api-key to update").build();
        }
        apiKeyEntity.setKey(apiKey);
        ApiKeyEntity keyEntity = this.apiKeyService.update(apiKeyEntity);
        return Response.ok((Object)keyEntity).build();
    }

    @Deprecated(forRemoval=true, since="v3.12")
    @POST
    @Path(value="_verify")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated, use GET /apis/{apiId}/subscriptions/_canCreate endpoint instead", notes="User must have the API_SUBSCRIPTION:READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API Key successfully checked", response=Boolean.class), @ApiResponse(code=400, message="Bad API Key parameter"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public Response verifyApiKeyAvailability(@ApiParam(name="apiKey", required=true) @CustomApiKey @NotNull @QueryParam(value="apiKey") String apiKey) {
        boolean available = this.apiKeyService.findByKey(apiKey).isEmpty();
        return Response.ok((Object)available).build();
    }
}

