/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class AbstractResource {
    public static final String ORGANIZATION_ADMIN = RoleScope.ORGANIZATION.name() + ":" + SystemRole.ADMIN.name();
    @Context
    protected SecurityContext securityContext;
    @Context
    protected UriInfo uriInfo;
    @Inject
    protected MembershipService membershipService;
    @Inject
    protected RoleService roleService;
    @Inject
    protected ApiService apiService;
    @Inject
    protected PermissionService permissionService;

    protected UserDetails getAuthenticatedUserDetails() {
        return (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
    }

    protected String getAuthenticatedUser() {
        return this.securityContext.getUserPrincipal().getName();
    }

    protected String getAuthenticatedUserOrNull() {
        return this.isAuthenticated() ? this.getAuthenticatedUser() : null;
    }

    protected boolean isAuthenticated() {
        return this.securityContext.getUserPrincipal() != null;
    }

    protected boolean isAdmin() {
        return this.isUserInRole(ORGANIZATION_ADMIN);
    }

    private boolean isUserInRole(String role) {
        return this.securityContext.isUserInRole(role);
    }

    protected boolean hasPermission(RolePermission permission, RolePermissionAction ... acls) {
        return this.hasPermission(permission, (String)null, acls);
    }

    protected boolean hasPermission(RolePermission permission, String referenceId, RolePermissionAction ... acls) {
        return this.isAuthenticated() && (this.isAdmin() || this.permissionService.hasPermission(permission, referenceId, acls));
    }

    protected boolean canReadAPIConfiguration() {
        if (!this.isAdmin()) {
            return this.retrieveApiMembership().findFirst().isPresent();
        }
        return true;
    }

    private Stream<MembershipEntity> retrieveApiMembership() {
        Stream streamUserMembership = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, this.getAuthenticatedUser(), MembershipReferenceType.API).stream();
        Stream<MembershipEntity> streamGroupMembership = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, this.getAuthenticatedUser(), MembershipReferenceType.GROUP).stream().filter(m -> m.getRoleId() != null && this.roleService.findById(m.getRoleId()).getScope().equals((Object)RoleScope.API));
        return Stream.concat(streamUserMembership, streamGroupMembership);
    }

    protected void canReadApi(String api) {
        if (!this.isAdmin()) {
            List memberships = this.retrieveApiMembership().collect(Collectors.toList());
            Set groups = memberships.stream().filter(m -> MembershipReferenceType.GROUP.equals((Object)m.getReferenceType())).map(m -> m.getReferenceId()).collect(Collectors.toSet());
            Set directMembers = memberships.stream().filter(m -> MembershipReferenceType.API.equals((Object)m.getReferenceType())).map(m -> m.getReferenceId()).collect(Collectors.toSet());
            if (directMembers.contains(api)) {
                return;
            }
            ApiQuery apiQuery = new ApiQuery();
            apiQuery.setGroups(new ArrayList(groups));
            apiQuery.setIds(Collections.singletonList(api));
            Collection strings = this.apiService.searchIds(apiQuery);
            boolean canReadAPI = strings.contains(api);
            if (!canReadAPI) {
                throw new ForbiddenAccessException();
            }
        }
    }

    protected UriBuilder getRequestUriBuilder() {
        return this.uriInfo.getRequestUriBuilder();
    }

    protected URI getLocationHeader(String ... paths) {
        UriBuilder requestUriBuilder = this.uriInfo.getRequestUriBuilder();
        for (String path : paths) {
            requestUriBuilder.path(path);
        }
        return requestUriBuilder.build(new Object[0]);
    }
}

