/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.AlertAnalyticsParam;
import io.gravitee.rest.api.management.rest.resource.param.AlertEventSearchParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.AlertAnalyticsQuery;
import io.gravitee.rest.api.model.AlertEventQuery;
import io.gravitee.rest.api.model.alert.AlertAnalyticsEntity;
import io.gravitee.rest.api.model.alert.AlertEventEntity;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertStatusEntity;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.alert.NewAlertTriggerEntity;
import io.gravitee.rest.api.model.alert.UpdateAlertTriggerEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AlertAnalyticsService;
import io.gravitee.rest.api.service.AlertService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Api(tags={"Platform Alerts"})
public class PlatformAlertsResource
extends AbstractResource {
    private static final String PLATFORM_REFERENCE_ID = "default";
    @Inject
    private AlertService alertService;
    @Inject
    private AlertAnalyticsService alertAnalyticsService;

    @GET
    @ApiOperation(value="List configured alerts of the platform", notes="User must have the MANAGEMENT_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of alerts", response=AlertTriggerEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.READ})})
    public List<AlertTriggerEntity> getPlatformAlerts(@QueryParam(value="event_counts") @DefaultValue(value="true") Boolean withEventCounts) {
        return withEventCounts != false ? this.alertService.findByReferenceWithEventCounts(AlertReferenceType.PLATFORM, PLATFORM_REFERENCE_ID) : this.alertService.findByReference(AlertReferenceType.PLATFORM, PLATFORM_REFERENCE_ID);
    }

    @GET
    @Path(value="analytics")
    @ApiOperation(value="List configured alerts of the platform", notes="User must have the MANAGEMENT_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of alerts", response=AlertTriggerEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.READ})})
    public AlertAnalyticsEntity getPlatformAlertsAnalytics(@BeanParam AlertAnalyticsParam param) {
        param.validate();
        return this.alertAnalyticsService.findByReference(AlertReferenceType.PLATFORM, PLATFORM_REFERENCE_ID, new AlertAnalyticsQuery.Builder().from(param.getFrom().longValue()).to(param.getTo().longValue()).build());
    }

    @GET
    @Path(value="status")
    @ApiOperation(value="Get alerting status", notes="User must have the MANAGEMENT_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Alerting status", response=AlertStatusEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.READ})})
    public AlertStatusEntity getPlatformAlertStatus() {
        return this.alertService.getStatus();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create an alert for the platform", notes="User must have the MANAGEMENT_ALERT[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Alert successfully created", response=AlertTriggerEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.CREATE})})
    public AlertTriggerEntity createPlatformAlert(@Valid @NotNull NewAlertTriggerEntity alertEntity) {
        alertEntity.setReferenceType(AlertReferenceType.PLATFORM);
        alertEntity.setReferenceId(PLATFORM_REFERENCE_ID);
        return this.alertService.create(alertEntity);
    }

    @Path(value="{alert}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an alert for the platform", notes="User must have the MANAGEMENT_ALERT[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Alert successfully updated", response=AlertTriggerEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.UPDATE})})
    public AlertTriggerEntity updatePlatformAlert(@PathParam(value="alert") String alert, @Valid @NotNull UpdateAlertTriggerEntity alertEntity) {
        alertEntity.setId(alert);
        alertEntity.setReferenceType(AlertReferenceType.PLATFORM);
        alertEntity.setReferenceId(PLATFORM_REFERENCE_ID);
        return this.alertService.update(alertEntity);
    }

    @POST
    @Path(value="{alert}")
    @ApiOperation(value="Associate the alert to multiple references (API, APPLICATION", notes="User must have the MANAGEMENT_ALERT[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Alert successfully associated"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.UPDATE})})
    public Response associatePlatformAlert(@PathParam(value="alert") String alert, @QueryParam(value="type") String type) {
        this.alertService.applyDefaults(alert, AlertReferenceType.valueOf((String)type.toUpperCase()));
        return Response.ok().build();
    }

    @Path(value="{alert}")
    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Delete an alert for the platform", notes="User must have the MANAGEMENT_ALERT[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Alert successfully deleted", response=AlertTriggerEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.DELETE})})
    public void deletePlatformAlert(@PathParam(value="alert") String alert) {
        this.alertService.delete(alert, PLATFORM_REFERENCE_ID);
    }

    @GET
    @Path(value="{alert}/events")
    @ApiOperation(value="Retrieve the list of events for an alert", notes="User must have the MANAGEMENT_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of events"), @ApiResponse(code=500, message="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.READ})})
    public Page<AlertEventEntity> getPlatformAlertEvents(@PathParam(value="alert") String alert, @BeanParam AlertEventSearchParam param) {
        return this.alertService.findEvents(alert, new AlertEventQuery.Builder().from(param.getFrom().longValue()).to(param.getTo().longValue()).pageNumber(param.getPage().intValue()).pageSize(param.getSize().intValue()).build());
    }
}

