/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.PortalNotificationDefaultReferenceId;
import io.gravitee.rest.api.management.rest.resource.ApiHeadersResource;
import io.gravitee.rest.api.management.rest.resource.CategoriesResource;
import io.gravitee.rest.api.management.rest.resource.DashboardsResource;
import io.gravitee.rest.api.management.rest.resource.EntrypointsResource;
import io.gravitee.rest.api.management.rest.resource.GroupsResource;
import io.gravitee.rest.api.management.rest.resource.MetadataResource;
import io.gravitee.rest.api.management.rest.resource.PlansResource;
import io.gravitee.rest.api.management.rest.resource.PortalNotificationSettingsResource;
import io.gravitee.rest.api.management.rest.resource.TagsResource;
import io.gravitee.rest.api.management.rest.resource.TenantsResource;
import io.gravitee.rest.api.management.rest.resource.ThemesResource;
import io.gravitee.rest.api.management.rest.resource.TopApisResource;
import io.gravitee.rest.api.management.rest.resource.configuration.application.registration.ClientRegistrationProvidersResource;
import io.gravitee.rest.api.management.rest.resource.configuration.dictionary.DictionariesResource;
import io.gravitee.rest.api.management.rest.resource.configuration.identity.IdentityProvidersResource;
import io.gravitee.rest.api.management.rest.resource.organization.RoleScopesResource;
import io.gravitee.rest.api.management.rest.resource.quality.QualityRulesResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.configuration.application.ApplicationTypesEntity;
import io.gravitee.rest.api.model.notification.NotifierEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.configuration.application.ApplicationTypeService;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import io.gravitee.rest.api.service.configuration.spel.SpelService;
import io.gravitee.rest.api.service.notification.Hook;
import io.gravitee.rest.api.service.notification.PortalHook;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Configuration"})
public class EnvironmentConfigurationResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private NotifierService notifierService;
    @Inject
    private ApplicationTypeService applicationTypeService;
    @Inject
    private FlowService flowService;
    @Inject
    private SpelService spelService;

    @GET
    @Path(value="/hooks")
    @ApiOperation(value="Get the list of available hooks")
    @Produces(value={"application/json"})
    public Hook[] getConfigurationHooks() {
        return (Hook[])Arrays.stream(PortalHook.values()).filter(h -> !h.isHidden()).toArray(Hook[]::new);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="notifiers")
    @ApiOperation(value="List of available notifiers")
    @ApiResponses(value={@ApiResponse(code=200, message="List of notifiers", response=NotifierEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_NOTIFICATION, acls={RolePermissionAction.READ})})
    public List<NotifierEntity> getPortalNotifiers() {
        return this.notifierService.list(NotificationReferenceType.PORTAL, PortalNotificationDefaultReferenceId.DEFAULT.name());
    }

    @Path(value="categories")
    public CategoriesResource getCategoryResource() {
        return (CategoriesResource)this.resourceContext.getResource(CategoriesResource.class);
    }

    @Path(value="groups")
    public GroupsResource getGroupResource() {
        return (GroupsResource)this.resourceContext.getResource(GroupsResource.class);
    }

    @Path(value="tags")
    @Deprecated
    public TagsResource getTagResource() {
        return (TagsResource)this.resourceContext.getResource(TagsResource.class);
    }

    @Path(value="tenants")
    @Deprecated
    public TenantsResource getTenantsResource() {
        return (TenantsResource)this.resourceContext.getResource(TenantsResource.class);
    }

    @Path(value="metadata")
    public MetadataResource getMetadataResource() {
        return (MetadataResource)this.resourceContext.getResource(MetadataResource.class);
    }

    @Deprecated
    @Path(value="rolescopes")
    public RoleScopesResource getRoleScopesResource() {
        return (RoleScopesResource)this.resourceContext.getResource(RoleScopesResource.class);
    }

    @Path(value="notificationsettings")
    public PortalNotificationSettingsResource getNotificationSettingsResource() {
        return (PortalNotificationSettingsResource)this.resourceContext.getResource(PortalNotificationSettingsResource.class);
    }

    @Path(value="top-apis")
    public TopApisResource getTopApisResource() {
        return (TopApisResource)this.resourceContext.getResource(TopApisResource.class);
    }

    @Path(value="plans")
    public PlansResource getPlansResource() {
        return (PlansResource)this.resourceContext.getResource(PlansResource.class);
    }

    @Path(value="dictionaries")
    public DictionariesResource getDictionariesResource() {
        return (DictionariesResource)this.resourceContext.getResource(DictionariesResource.class);
    }

    @Path(value="apiheaders")
    public ApiHeadersResource getApiHeadersResource() {
        return (ApiHeadersResource)this.resourceContext.getResource(ApiHeadersResource.class);
    }

    @Deprecated
    @Path(value="identities")
    public IdentityProvidersResource getAuthenticationProvidersResource() {
        return (IdentityProvidersResource)this.resourceContext.getResource(IdentityProvidersResource.class);
    }

    @Path(value="applications/registration/providers")
    public ClientRegistrationProvidersResource getClientRegistrationProvidersResource() {
        return (ClientRegistrationProvidersResource)this.resourceContext.getResource(ClientRegistrationProvidersResource.class);
    }

    @GET
    @Path(value="applications/types")
    @ApiOperation(value="Get the list of enabled application types")
    @Produces(value={"application/json"})
    public Response getEnabledApplicationTypes() {
        ApplicationTypesEntity enabledApplicationTypes = this.applicationTypeService.getEnabledApplicationTypes();
        return Response.ok((Object)enabledApplicationTypes.getData()).build();
    }

    @Path(value="entrypoints")
    @Deprecated
    public EntrypointsResource getEntryPointsResource() {
        return (EntrypointsResource)this.resourceContext.getResource(EntrypointsResource.class);
    }

    @Path(value="quality-rules")
    public QualityRulesResource getQualityRulesResource() {
        return (QualityRulesResource)this.resourceContext.getResource(QualityRulesResource.class);
    }

    @Path(value="dashboards")
    public DashboardsResource getDashboardsResource() {
        return (DashboardsResource)this.resourceContext.getResource(DashboardsResource.class);
    }

    @Path(value="themes")
    public ThemesResource getThemesResource() {
        return (ThemesResource)this.resourceContext.getResource(ThemesResource.class);
    }

    @GET
    @Path(value="spel/grammar")
    @Produces(value={"application/json"})
    public JsonNode getGrammar() {
        return this.spelService.getGrammar();
    }
}

