/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.Subscription;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationSubscriptionApiKeysResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Application Subscriptions"})
public class ApplicationSubscriptionResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private PlanService planService;
    @Inject
    private ApiKeyService apiKeyService;
    @Inject
    private ApiService apiService;
    @Inject
    private UserService userService;
    @PathParam(value="application")
    @ApiParam(name="application", hidden=true)
    private String application;
    @PathParam(value="subscription")
    @ApiParam(name="subscription", hidden=true)
    private String subscription;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get subscription information", notes="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Subscription information", response=Subscription.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public Subscription getApplicationSubscription() {
        return this.convert(this.subscriptionService.findById(this.subscription));
    }

    @DELETE
    @Produces(value={"application/json"})
    @ApiOperation(value="Close the subscription", notes="User must have the APPLICATION_SUBSCRIPTION[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Subscription has been closed successfully", response=Subscription.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response closeApplicationSubscription() {
        SubscriptionEntity subscriptionEntity = this.subscriptionService.findById(this.subscription);
        if (subscriptionEntity.getApplication().equals(this.application)) {
            return Response.ok((Object)this.convert(this.subscriptionService.close(this.subscription))).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @Deprecated(forRemoval=true, since="v3.12")
    @GET
    @Path(value="/keys")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated, use GET /applications/{applicationId}/subscriptions/{subscriptionId}/apikeys instead", notes="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of API Keys for a subscription", response=ApiKeyEntity.class, responseContainer="Set"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public List<ApiKeyEntity> getApiKeysForApplicationSubscription() {
        return this.apiKeyService.findBySubscription(this.subscription);
    }

    @Deprecated(forRemoval=true, since="v3.12")
    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated, use POST /applications/{applicationId}/subscriptions/{subscriptionId}/apikeys/_renew instead", notes="User must have the MANAGE_API_KEYS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="A new API Key", response=ApiKeyEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response renewApiKeyForApplicationSubscription() {
        ApiKeyEntity apiKeyEntity = this.apiKeyService.renew(this.subscription);
        return Response.created((URI)this.getLocationHeader("keys", apiKeyEntity.getKey())).entity((Object)apiKeyEntity).build();
    }

    @Deprecated(forRemoval=true, since="v3.12")
    @DELETE
    @Path(value="/keys/{key}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated, use DELETE /applications/{applicationId}/subscriptions/{subscriptionId}/apikeys/{apiKeyId}", notes="User must have the MANAGE_API_KEYS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="API key successfully revoked"), @ApiResponse(code=400, message="API Key does not correspond to the subscription"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response revokeApiKeyForApplicationSubscription(@PathParam(value="key") String apiKey) {
        SubscriptionEntity subscriptionEntity = this.subscriptionService.findById(this.subscription);
        ApiKeyEntity apiKeyEntity = this.apiKeyService.findByKeyAndApi(apiKey, subscriptionEntity.getApi());
        if (apiKeyEntity.getSubscription() != null && !this.subscription.equals(apiKeyEntity.getSubscription())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'key' parameter does not correspond to the subscription").build();
        }
        this.apiKeyService.revoke(apiKeyEntity, true);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Path(value="apikeys")
    public ApplicationSubscriptionApiKeysResource getApiSubscriptionApiKeysResourceResource() {
        return (ApplicationSubscriptionApiKeysResource)this.resourceContext.getResource(ApplicationSubscriptionApiKeysResource.class);
    }

    private Subscription convert(SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(subscriptionEntity.getCreatedAt());
        subscription.setUpdatedAt(subscriptionEntity.getUpdatedAt());
        subscription.setStartingAt(subscriptionEntity.getStartingAt());
        subscription.setEndingAt(subscriptionEntity.getEndingAt());
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt());
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setReason(subscriptionEntity.getReason());
        subscription.setRequest(subscriptionEntity.getRequest());
        subscription.setStatus(subscriptionEntity.getStatus());
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), this.userService.findById(subscriptionEntity.getSubscribedBy(), true).getDisplayName()));
        PlanEntity plan = this.planService.findById(subscriptionEntity.getPlan());
        subscription.setPlan(new Subscription.Plan(plan.getId(), plan.getName()));
        subscription.getPlan().setSecurity(plan.getSecurity());
        ApiEntity api = this.apiService.findById(subscriptionEntity.getApi());
        subscription.setApi(new Subscription.Api(api.getId(), api.getName(), api.getVersion(), new Subscription.User(api.getPrimaryOwner().getId(), api.getPrimaryOwner().getDisplayName())));
        subscription.setClosedAt(subscriptionEntity.getClosedAt());
        subscription.setPausedAt(subscriptionEntity.getPausedAt());
        return subscription;
    }
}

