/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.EventService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Api(tags={"API Events"})
public class ApiEventResource
extends AbstractResource {
    @Inject
    private EventService eventService;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;
    @PathParam(value="eventId")
    @ApiParam(name="eventId", hidden=true)
    private String eventId;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an API event with its id", notes="User must have the READ API_EVENT permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API event", response=EventEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_EVENT, acls={RolePermissionAction.READ})})
    public Response getEvent() {
        return Response.ok((Object)this.eventService.findById(this.eventId)).build();
    }
}

