/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.quality;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.quality.QualityRuleResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.quality.NewQualityRuleEntity;
import io.gravitee.rest.api.model.quality.QualityRuleEntity;
import io.gravitee.rest.api.service.QualityRuleService;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Configuration"})
public class QualityRulesResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private QualityRuleService qualityRuleService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List quality rules")
    @ApiResponses(value={@ApiResponse(code=200, message="List of quality rules", response=QualityRuleEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public List<QualityRuleEntity> getQualityRules() {
        if (!this.hasPermission(RolePermission.ENVIRONMENT_QUALITY_RULE, RolePermissionAction.READ) && !this.canReadAPIConfiguration()) {
            throw new ForbiddenAccessException();
        }
        return this.qualityRuleService.findAll();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a quality rule", notes="User must have the MANAGEMENT_QUALITY_RULE[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Quality rule successfully created", response=QualityRuleEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_QUALITY_RULE, acls={RolePermissionAction.CREATE})})
    public QualityRuleEntity createQualityRule(@Valid @NotNull NewQualityRuleEntity newQualityRuleEntity) {
        return this.qualityRuleService.create(newQualityRuleEntity);
    }

    @Path(value="{id}")
    public QualityRuleResource getQualityRuleResource() {
        return (QualityRuleResource)this.resourceContext.getResource(QualityRuleResource.class);
    }
}

